package clinical.upload;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/**
 * 
 * @version $Id: MetaDataLoader.java 62 2009-05-29 23:54:50Z bozyurt $
 * @author I. Burak Ozyurt
 */

public class MetaDataLoader {
	protected Document doc;
	protected Map<String, ColumnInfo> colInfoMap = new HashMap<String, ColumnInfo>();
	protected Map<String, TypeInfo> typeInfoMap = new HashMap<String, TypeInfo>();
	protected Map<String, String> old2newNameMap = new HashMap<String, String>();

	public MetaDataLoader(String filename) throws JDOMException, IOException {
		SAXBuilder builder = null;
		builder = new SAXBuilder(false); // no validation
		doc = builder.build(new File(filename));
	}

	public Map<String, TypeInfo> getTypeInfoMap() {
		return typeInfoMap;
	}

	public Map<String, ColumnInfo> getColInfoMap() {
		return colInfoMap;
	}

	public Map<String, String> getOld2NewNameMap() {
		return old2newNameMap;
	}

	public void parse() {
		Element root = doc.getRootElement();
		Element types = root.getChild("types");
		parseTypes(types);
		Element columns = root.getChild("columns");
		parseColumns(columns);
	}

	public void parseTypes(Element typesElem) {
		List<?> types = typesElem.getChildren("type");
		for (Object element : types) {
			Element type = (Element) element;
			TypeInfo typeInfo = new TypeInfo();
			typeInfo.setName(type.getAttributeValue("name").toLowerCase());
			typeInfo.setHandlerClass(type.getAttributeValue("handlerClass"));

			typeInfoMap.put(typeInfo.getName(), typeInfo);
			List<?> props = type.getChildren("property");
			if (props == null)
				continue;
			for (Iterator<?> it2 = props.iterator(); it2.hasNext();) {
				Element prop = (Element) it2.next();
				typeInfo.addProperty(prop.getAttributeValue("name"), prop
						.getAttributeValue("value"));
			}
		}
	}

	public void parseColumns(Element colsElem) {
		List<?> cols = colsElem.getChildren("column");
		for (Iterator<?> it = cols.iterator(); it.hasNext();) {
			Element column = (Element) it.next();

			ColumnInfo ci = new ColumnInfo();
			ci.setName(column.getAttributeValue("name"));
			String newName = column.getAttributeValue("newName");
			if (newName == null) {
				ci.setNewName(ci.getName());
			} else {
				ci.setNewName(newName);
			}
			TypeInfo typeInfo = typeInfoMap.get(column
					.getAttributeValue("type").toLowerCase());
			if (typeInfo == null)
				throw new RuntimeException(column.getAttributeValue("type")
						+ " is not a valid type for column " + ci.getName());
			ci.setType(typeInfo);
			if (column.getAttributeValue("sqlType") != null)
				ci
						.setSqlType(column.getAttributeValue("sqlType")
								.toLowerCase());
			Element vmElem = column.getChild("value-map");
			if (vmElem != null)
				parseValueMap(ci, vmElem);
			Element condElem = column.getChild("conditioner");
			if (condElem != null) {
				ConditionerInfo condInfo = new ConditionerInfo();
				condInfo.setClassName(condElem.getAttributeValue("classname"));
				condInfo.setMethodName(condElem.getAttributeValue("method"));
				ci.setConditioner(condInfo);
			}

			if (column.getAttributeValue("store") != null) {
				ci.setStored(column.getAttributeValue("store")
						.equalsIgnoreCase("true"));
			}

			ci.setDateCol(column.getAttributeValue("date-col"));
			ci.setVisitType(column.getAttributeValue("visit-type"));
			ci.setComments(column.getAttributeValue("comments"));

			// column Infos are hashed by the newName which is the assessment
			// score name
			colInfoMap.put(ci.getNewName(), ci);
			old2newNameMap.put(ci.getName(), ci.getNewName());

		}

	}

	void parseValueMap(ColumnInfo ci, Element vmElem) {
		List<?> maps = vmElem.getChildren("map");
		for (Iterator<?> it = maps.iterator(); it.hasNext();) {
			Element mapElem = (Element) it.next();
			ci.addMap(mapElem.getAttributeValue("from"), mapElem
					.getAttributeValue("to"));
		}
	}
}