package clinical.upload;

import java.sql.Connection;
import java.util.List;
import java.util.Map;

import clinical.server.ExperimentManager;
import clinical.server.dao.ProtocolDAO;
import clinical.server.vo.Expcomponent;
import clinical.server.vo.Protocol;
import clinical.web.Constants;
import clinical.web.DAOFactory;

/**
 * @author I. Burak Ozyurt
 * @version $Id: UploadHelper.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class UploadHelper {
	private UploadHelper() {
	}

	public static List<Protocol> getProtocols(String dbID, Connection con)
			throws Exception {
		ProtocolDAO dao = DAOFactory.createProtocolDAO(dbID);
		List<Protocol> protocols = dao.find(con, new Protocol());
		return protocols;
	}

	public static Protocol findProtocol(String visitType,
			List<Protocol> protocols) {
		/**
		 * @todo make this to use ge header info to figure out the appropriate
		 *       protocol
		 */
		for (Protocol protocol : protocols) {
			if (visitType.equalsIgnoreCase(Constants.VISIT_TYPE_SCAN)) {
				if (protocol.getProtocolid().equalsIgnoreCase("jernigan_spgr"))
					return protocol;
			} else if (visitType
					.equalsIgnoreCase(Constants.VISIT_TYPE_CLINICAL)) {
				if (protocol.getProtocolid().equalsIgnoreCase(
						"ucsd_adrc_battery"))
					return protocol;
			}
		}
		return null;
	}

	public static void removeVisits(Connection con,
			List<Expcomponent> allVisits, int lowVisitID, int highVisitID,
			String experimentName, Map<String,String> resGroupMap, String owner, String modUser)
			throws Exception {
		ExperimentManager expMan = new ExperimentManager();
		for (Expcomponent visit : allVisits) {
			String birnID = visit.getSubjectid();
			if (birnID == null) {
				continue;
			}
			String researchGroupName = (String) resGroupMap.get(birnID);
			if (researchGroupName == null) {
				System.err.println("Skipping " + birnID
						+ " research group was null!");
				continue;
			}

			expMan.removeVisitsForSubject(con, birnID, experimentName,
					researchGroupName, lowVisitID, highVisitID, owner, modUser);

		}
	}

}