package clinical.utils;

/**
 * @author I. Burak Ozyurt
 * @version $Id: Assertion.java 164 2010-02-05 18:48:15Z bozyurt $
 */
public class Assertion {

	protected Assertion() {}
	
	public static void assertNotNull(Object value) {
		if ( value == null) {
			throw new RuntimeException("Object was not expected to be null!");			
		}
	}
	
	public static void assertNotNull(Object value, String msg) {
		if ( value == null) {
			throw new RuntimeException("Object was not expected to be null!\n" + msg);			
		}
	}
	
	public static void assertTrue(boolean exprValue) {
		if ( !exprValue) {
			throw new RuntimeException("The expression evaluated to <false>! Expected <true>");			
		}
	}
	
	public static void assertFalse(boolean exprValue) {
		if ( exprValue) {
			throw new RuntimeException("The expression evaluated to <true>! Expected <false>");			
		}
	}
}
