package clinical.utils;

import java.util.Enumeration;

import javax.servlet.http.HttpSession;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: HTTPUtils.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class HTTPUtils {
	protected HTTPUtils() {
	}

	/**
	 * Returns the contents of a HTTP Session object as a string
	 * 
	 * @param session
	 *            an HTTP session object
	 * @return the content dump as a string
	 */
	@SuppressWarnings("unchecked")
	public static String dumpSessionContents(HttpSession session) {
		StringBuffer sb = new StringBuffer(2048);
		String lineSep = System.getProperty("line.separator");
		sb.append("sessionID=").append(session.getId()).append(lineSep);
		Enumeration enumeration = session.getAttributeNames();
		while (enumeration.hasMoreElements()) {
			String name = (String) enumeration.nextElement();
			sb.append("name=").append(name).append(" value=").append(
					session.getAttribute(name)).append(lineSep);
		}
		sb.append("---------------------------------").append(lineSep);
		return sb.toString();
	}

}