package clinical.utils;

import java.io.IOException;

import edu.sdsc.grid.io.srb.SRBFileSystem;

/**
 * @author I. Burak Ozyurt
 * @version $Id: SRBFileSystemAdapter.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class SRBFileSystemAdapter {
	protected SRBFileSystem srbFileSystem = null;
	protected int accessCount = 0;
	protected int maxCount = 10000;

	public SRBFileSystemAdapter() throws Exception {
		srbFileSystem = new SRBFileSystem();
	}

	public SRBFileSystem getSrbFileSystem() throws IOException {
		if (accessCount < maxCount) {
			++accessCount;
			System.out.println("Access:"+accessCount);
			return srbFileSystem;
		} else {
			try {
				srbFileSystem.close();
			} catch (IOException e) {
				e.printStackTrace();
			}; 
			srbFileSystem = new SRBFileSystem();
			accessCount = 0;
			return getSrbFileSystem();
		}
	}
	
	public SRBFileSystem getNewSrbFileSystem() throws Exception {
		accessCount = maxCount;
		return getSrbFileSystem();
	}
		
	
	public void shutdown() {
		if ( srbFileSystem != null) {
			try {
				srbFileSystem.close();
				srbFileSystem = null;
			} catch (IOException e) {
                 // ignore
			}; 
		}
	}

}
