package clinical.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: ThreadPoolMan.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class ThreadPoolMan {
	protected ExecutorService executorService;
	protected static ThreadPoolMan instance = null;

	protected ThreadPoolMan(int nThreads) {
		executorService = Executors.newFixedThreadPool(nThreads);
	}

	public static synchronized ThreadPoolMan create(int nThreads) {
		if (instance == null)
			instance = new ThreadPoolMan(nThreads);
		return instance;
	}

	public static synchronized ThreadPoolMan getInstance() {
		if (instance == null)
			throw new RuntimeException(
					"ThreadPoolMan is not properly initialized!");
		return instance;
	}

	public ExecutorService getExecutorService() {
		return executorService;
	}

}
