package clinical.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import clinical.web.exception.ValidationException;

public class ValidationUtils {
	public static Pattern jdbcPattern = Pattern.compile("^jdbc:(\\w+):.+$");

	public static void notEmpty(String fieldName, String fieldValue)
			throws ValidationException {
		if (fieldValue == null || fieldValue.trim().length() == 0) {
			throw new ValidationException("A non empty '" + fieldName
					+ "' needs to be specified!");
		}
	}

	// jdbc:oracle:thin:@fmri-gpop.nbirn.net:1521:orcl1
	// jdbc:postgresql://localhost/fbirn_test2
	public static String validJDBCUrl(String fieldName, String jdbcUrl)
			throws ValidationException {
		Matcher m = jdbcPattern.matcher(jdbcUrl);
		if (!m.find()) {
			throw new ValidationException("Not a valid JDBC URL for '"
					+ fieldName + "' :" + jdbcUrl);
		}
		return m.group(1);
	}

	public static void validDBId(String fieldName, String dbId)
			throws ValidationException {
		Pattern p = Pattern.compile("^\\w+_\\w+$");
		if (!p.matcher(dbId).find()) {
			throw new ValidationException("Not a valid database ID!");
		}
	}

	public static void validHTTPURL(String fieldName, String urlStr)
			throws ValidationException {
		Pattern p = Pattern.compile("^https?:");
		if (!p.matcher(urlStr).find())
			throw new ValidationException("Not a valid HTTP URL for '"
					+ fieldName + "' :" + urlStr);
	}
}
