package clinical.web;

import java.util.List;
import java.util.Map;

import clinical.server.vo.Dataarchive;
import clinical.server.vo.Expsegment;
import clinical.web.common.UserInfo;
import clinical.web.vo.AssessmentInfo;
import clinical.web.vo.RawDataObject;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: IImageDataService.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public interface IImageDataService {

	public List<RawDataObject> getRawData(String siteID, UserInfo userInfo,
			int[] expIDs, List<String> subjectIDList, String[] objectTypes, boolean version)
			throws Exception;

	/**
	 * 
	 * @param userInfo
	 * @param expIDs
	 * @param subjectIDList
	 * @param objectTypes
	 * @param verbose
	 * @return
	 * @throws Exception
	 */
	public List<RawDataObject> getRawData(UserInfo userInfo, int[] expIDs,
			List<String> subjectIDList, String[] objectTypes, boolean verbose) throws Exception;

	public Map<String, Map<String,Expsegment>> getSegments(String siteID,
			UserInfo userInfo, List<String> expNames, List<String> subjectIDList)
			throws Exception;

	/**
	 * 
	 * @param userInfo
	 * @param expIDs
	 * @param subjectIDList
	 * @return
	 * @throws Exception
	 */
	public List<?> getDerivedData(UserInfo userInfo, int[] expIDs,
			List<String> subjectIDList) throws Exception;

	/**
	 * 
	 * @param userInfo
	 * @param expIDs
	 * @param subjectIDList
	 * @return
	 * @throws Exception
	 */
	public List<AssessmentInfo> getAssessmentInfos(UserInfo userInfo,
			int[] expIDs, List<String> subjectIDList) throws Exception;

	public List<AssessmentInfo> getAssessmentInfos(String siteID, int[] expIDs,
			List<String> subjectIDList) throws Exception;

	/**
	 * 
	 * @param userInfo
	 * @return
	 * @throws Exception
	 */
	public Map<String, List<Dataarchive>> getArchivedDataByProject(
			UserInfo userInfo) throws Exception;

}
