package clinical.web;

import clinical.web.common.IDBCache;
import clinical.web.common.IDBPoolService;
import clinical.web.common.ISecurityService;
import clinical.web.common.query.OracleSQLDialect;
import clinical.web.common.query.PostgresSQLDialect;
import clinical.web.common.security.DBConfig;
import clinical.web.exception.BaseException;
import clinical.web.services.AppConfigService;
import clinical.web.services.DBCache;
import clinical.web.services.DBPoolService;
import clinical.web.services.OracleSequenceHelper;
import clinical.web.services.PostgresSequenceHelper;
import clinical.web.services.SecurityService;
import clinical.web.services.SimpleSecurityService;

/**
 * @author I. Burak Ozyurt
 * @version $Id: MinimalServiceFactory.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class MinimalServiceFactory {
	private static boolean mimimalOpMode = false;
	
	public static ISecurityService getSecurityService() throws BaseException {
		if ( isMimimalOpMode()) {
			return SimpleSecurityService.getInstance();
		} else {
		   return (ISecurityService) SecurityService.getInstance();
		}
	}
	
	public static ISequenceHelper getSequenceHelper(String dbID)
			throws BaseException {
		ISecurityService isec = SimpleSecurityService.getInstance();
		String dbType = isec.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return (ISequenceHelper) OracleSequenceHelper.getInstance(dbID,
					dbType);
		} else if (dbType.equals(DBConfig.POSTGRES)) {
			return (ISequenceHelper) PostgresSequenceHelper.getInstance(dbID,
					dbType);
		} else {
			throw new BaseException("Not a supported database type:" + dbType);
		}
	}
	
	public static ISQLDialect getSQLDialect(String dbID) throws BaseException {
		ISecurityService isec = SimpleSecurityService.getInstance();
		String dbType = isec.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new OracleSQLDialect();
		} else if (dbType.equals(DBConfig.POSTGRES)) {
			return new PostgresSQLDialect();
		} else {
			throw new BaseException("Not a supported database type:" + dbType);
		}
	}
	
	public static IDBPoolService getPoolService(String dbID) {
		return DBPoolService.getInstance(dbID);
	}
	
	public static IAppConfigService getAppConfigService() throws BaseException {
		return AppConfigService.getInstance();
	}
	
	public static IDBCache getDBCache(String dbID) throws BaseException {
		return (IDBCache) DBCache.getInstance(dbID);
	}
	
	public synchronized static boolean isMimimalOpMode() {
		return mimimalOpMode;
	}

	public synchronized static void setMimimalOpMode(boolean mimimalOpMode) {
		MinimalServiceFactory.mimimalOpMode = mimimalOpMode;
	}
}
