package clinical.web;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.utils.Executor;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBRandomAccessFile;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: SRBUtils.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class SRBUtils {
	private static Log log = LogFactory.getLog("image");

	protected SRBUtils() {
	}

	protected static String prepareScript(IAppConfigService configService, String scriptName) {
		String scriptPath = configService.getParamValue("script_path");
		StringBuffer buf = new StringBuffer(96);
		if (scriptPath != null) {
			buf.append(scriptPath).append(File.separator).append(scriptName);
		} else
			buf.append(scriptName);
		return buf.toString();
	}

	protected static Executor prepareExecutor(IAppConfigService configService) {
		String home = configService.getParamValue("proc.env.home");
		String path = configService.getParamValue("proc.env.path");
		String dcmPath = configService.getParamValue("proc.env.dcmpath");
		String pwd = configService.getParamValue("proc.env.pwd");
		String perl5lib = configService.getParamValue("proc.env.perl5lib");
		String perlExec = configService.getParamValue("perl_executable");

		Executor executor = new Executor(perlExec, true);
		executor.addEnvParam("PATH", path);
		executor.addEnvParam("HOME", home);
		executor.addEnvParam("DCMDICTPATH", dcmPath);
		executor.addEnvParam("PERL5LIB", perl5lib);
		executor.addEnvParam("PWD", pwd);

		return executor;
	}

	public static boolean saveFilesForStats(String srbCollection,
			String csvFile, String infoFile, IAppConfigService configService) throws Exception {
		Executor executor = prepareExecutor(configService);

		String args = prepareScript(configService, "upload_files.pl") + " "
				+ srbCollection + " " + csvFile + " " + infoFile;
		try {
			int rc = executor.execute(args);
			return (rc == 0);
		} catch (Exception x) {
			log.error("saveFilesForStats", x);
			throw x;
		}
	}

	public static void loadFile(SRBFile srbFile, String outFile)
			throws IOException {
		SRBRandomAccessFile in = null;
		BufferedOutputStream out = null;
		try {
			in = new SRBRandomAccessFile(srbFile, "r");
			out = new BufferedOutputStream(new FileOutputStream(outFile), 4096);

			int bytesRead;
			byte[] buffer = new byte[4096];
			while ((bytesRead = in.read(buffer, 0, buffer.length)) > 0) {
				out.write(buffer, 0, bytesRead);
			}
		} finally {
			if (out != null)
				try {
					out.close();
				} catch (Exception x) {
				}
			if (in != null)
				try {
					in.close();
				} catch (Exception x) {
				}
		}
	}

	public static void saveFile(String inFile, SRBFile srbFile)
			throws IOException {
		SRBRandomAccessFile out = null;
		BufferedInputStream in = null;
		try {
			out = new SRBRandomAccessFile(srbFile, "rw");
			in = new BufferedInputStream(new FileInputStream(inFile), 4096);

			int bytesRead;
			byte[] buffer = new byte[4096];

			while ((bytesRead = in.read(buffer, 0, buffer.length)) > 0) {
				out.write(buffer, 0, bytesRead);
			}
		} finally {
			if (out != null)
				try {
					out.close();
				} catch (Exception x) {
				}
			if (in != null)
				try {
					in.close();
				} catch (Exception x) {
				}
		}
	}

	public static void srbPut(String localFilePath, String userInfoFile,
			String srbCollection) throws IOException {
		SRBAccount account = null;
		SRBFileSystem sfs = null;
		SRBFile srbFile = null;
		try {
			account = new SRBAccount(userInfoFile);
			sfs = new SRBFileSystem(account);
			String filename = new File(localFilePath).getName();
			srbFile = new SRBFile(sfs, srbCollection);
			srbFile = new SRBFile(srbFile, filename);
			log.debug(">>SrbFile=" + srbFile.toString());
			saveFile(localFilePath, srbFile);
		} finally {
			if (sfs != null)
				try {
					sfs.close();
				} catch (Exception x) {
				}
		}
	}

}