package clinical.web;

import clinical.web.common.UserInfo;

/**
 * Holder of logged in user information during the user session.
 * 
 * @version $Id: UserContainer.java 62 2009-05-29 23:54:50Z bozyurt $
 * @author I. Burak Ozyurt
 */

public class UserContainer implements java.io.Serializable {
	private static final long serialVersionUID = -2693584632604382184L;
	private UserInfo userInfo;
	private String dbID;

	public UserContainer(UserInfo ui, String dbID) {
		this.userInfo = ui;
		this.dbID = dbID;
	}

	public UserInfo getUserInfo() {
		return this.userInfo;
	}

	public String toString() {
		if (getUserInfo() != null)
			return getUserInfo().getName();
		return "no user login";
	}

	public String getDbID() {
		return dbID;
	}

}