package clinical.web.actions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONObject;

import clinical.cache.CacheUtils;
import clinical.server.vo.Assessmentscorecode;
import clinical.server.vo.Experiment;
import clinical.server.vo.Storedquery;
import clinical.utils.Assertion;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.IAnalysisResultService;
import clinical.web.IAssessmentService;
import clinical.web.IRemoteDBServices;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.UserInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.forms.AsQueryBuilderForm;
import clinical.web.forms.SaveQueryForm;
import clinical.web.forms.StoredQuerySelector;
import clinical.web.helpers.ExperimentSelector;
import clinical.web.helpers.QueryWizardHelper;
import clinical.web.vo.AssessmentQueryInfo;
import clinical.web.vo.QueryInfo;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentQueryAction.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class AssessmentQueryAction extends BaseLookupDispatchAction {
	protected Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(AssessmentQueryAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.aq.show", "show");
		map.put("action.aq.load_saved_query", "loadSavedQuery");
		map.put("action.aq.query", "query");
		map.put("action.aq.msquery", "multiSiteQuery");

		map.put("action.aq.save_query", "saveQuery");
		map.put("action.aq.get_scorecodes", "getScorecodes");
		return map;
	}

	public ActionForward show(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("in show");
		IDBCache dbCache = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			IAssessmentService asService = ServiceFactory
					.getAssessmentService(dbID);
			IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();
			dbCache = ServiceFactory.getDBCache(dbID);
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);

			List<AssessmentSelectionInfo> asiList = rds
					.getAllAssessmentsWithScores(primarySiteID);
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;

			queryForm.clean();

			IAnalysisResultService ars = ServiceFactory.getAnalysisResultService(dbID);

			boolean supportAnalysisQuery = ars.hasAnalysisMetaData();
			queryForm.setSupportAnalysisQuery(supportAnalysisQuery);
			boolean supportAssessmentQuery = !asiList.isEmpty();
			queryForm.setSupportAssessmentQuery(supportAssessmentQuery);

			for (AssessmentSelectionInfo asi : asiList) {
				queryForm.addAssessment(asi);
			}
			QueryInfo qi = queryForm.getQueryInfo();
			if (qi == null) {
				qi = new QueryInfo(new AssessmentQueryInfo(asiList));
				queryForm.setQueryInfo(qi);
			} else {
				if (qi.getAqi() != null && qi.getAqi().hasQueryParts()) {
					qi.getAqi().resetAllSelected();
				}
			}

			// prepare the stored query summaries for this user
			QueryWizardHelper.prepareStoredQueryDescriptions(ui, asService, ui
					.getPerceivedName(), queryForm);

			QueryWizardHelper.prepareExperimentSelector(ui, queryForm, dbCache);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}


	public ActionForward query(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("**** query");
		AsQueryBuilderForm queryForm = null;
		try {
			UserInfo ui = getUserInfo(request);
			String queryString = request.getParameter("queryString");
			Assertion.assertNotNull(queryString);
			log.info("queryString:" + queryString);

			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			queryForm = (AsQueryBuilderForm) form;
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);

			QueryAggregator qa = new QueryAggregator(dbID, ui, queryForm);

			qa.handleQuery(queryString, queryForm.getDdQueryString(),
					primarySiteID);

			return mapping.findForward(Constants.FORWARD_RESULTS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		} finally {
			// clean state for next query
			if (queryForm != null) {
				queryForm.setDdQueryString(null);
				queryForm.setCaQueryString(null);
			}
		}
	}

	public ActionForward multiSiteQuery(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("**** multiSiteQuery");
		AsQueryBuilderForm queryForm = null;
		try {
			UserInfo ui = getUserInfo(request);
			String queryString = request.getParameter("queryString");
			Assertion.assertNotNull(queryString);
			log.info("queryString:" + queryString);

			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			queryForm = (AsQueryBuilderForm) form;
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);

			QueryAggregator qa = new QueryAggregator(dbID, ui, queryForm);

			qa.handleMultisiteQuery(queryString, queryForm.getDdQueryString(),
					primarySiteID);

			return mapping.findForward(Constants.FORWARD_RESULTS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		} finally {
			// clean state for next query
			if (queryForm != null) {
				queryForm.setDdQueryString(null);
				queryForm.setCaQueryString(null);
			}
		}

	}

	public ActionForward loadSavedQuery(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		IAssessmentService asService = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			asService = ServiceFactory.getAssessmentService(dbID);

			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
			StoredQuerySelector sqs = queryForm.getSavedQuerySelector();

			IDBCache dbCache = ServiceFactory.getDBCache(dbID);

			log.info("selected query ID=" + sqs.getSelectedQueryID());
			JSONObject js = QueryWizardHelper.loadJSONQueryFromDB(ui,
					asService, sqs.getSelectedQueryID(), ui.getPerceivedName());
			QueryInfo qi = queryForm.getQueryInfo();
			Assertion.assertNotNull(qi);
			// System.out.println(js.toString(2));
			qi.jsonToQuery(js);

			// set assessment query
			qi.prepareStoredQuery();

			ExperimentSelector expSelector = queryForm.getExpSelector();
			if (expSelector == null) {
				QueryWizardHelper.prepareExperimentSelector(ui, queryForm,
						dbCache);
				expSelector = queryForm.getExpSelector();
			}
			expSelector.setSelectedExpID(GenUtils.toInt(qi.getExpIDStr(), -1));

			return mapping.findForward(Constants.SUCCESS);

		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward saveQuery(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		IAssessmentService asService;
		try {
			UserInfo ui = getUserInfo(request);
			String queryString = request.getParameter("queryString");
			Assertion.assertNotNull(queryString);
			log.info("queryString:" + queryString);
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;

			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			asService = ServiceFactory.getAssessmentService(dbID);

			JSONObject js = new JSONObject(queryString);
			QueryInfo qi = queryForm.getQueryInfo();
			if (qi == null) {
				qi = new QueryInfo(AssessmentQueryInfo.initializeFromJSON(js));
				queryForm.setQueryInfo(qi);
			} else {
				if (qi.getAqi() == null) {
					qi.setAqi(AssessmentQueryInfo.initializeFromJSON(js));
				} else {
					qi.getAqi().updateQueryFromJSON(js);
				}
			}
			qi.prepareStoredQuery();

			SaveQueryForm sqForm = (SaveQueryForm) session
					.getAttribute(Constants.STORED_QUERY_FORM_KEY);
			if (sqForm != null) {
				sqForm.setDescription("");
				sqForm.getStoredQueryDescriptions().clear();
			} else {
				sqForm = new SaveQueryForm();
				session.setAttribute(Constants.STORED_QUERY_FORM_KEY, sqForm);
			}
			List<Storedquery> storedQueries = asService
					.getAvailableStoredQueries(ui, ui.getPerceivedName());
			for (Storedquery sq : storedQueries) {
				sqForm.addStoredQueryDescription(sq.getDescription());
			}

			return mapping.findForward(Constants.SAVE_QUERY);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward getScorecodes(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			UserInfo ui = getUserInfo(request);
			System.out.println(":::: getScorecodes");
			HttpSession session = request.getSession(false);

			String asID = request.getParameter("asID");
			Assertion.assertNotNull(asID);
			String scoreName = request.getParameter("scoreName");
			Assertion.assertNotNull(scoreName);
			String key = asID + "_" + scoreName;
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			IDBCache dbCache = ServiceFactory.getDBCache(dbID);
			Map<String, List<Assessmentscorecode>> scoreCodeMap = dbCache
					.getScoreCodeMap(ui, false);
			JSONObject js = new JSONObject();
			js.put("asID", asID);
			js.put("scoreName", scoreName);
			List<Assessmentscorecode> scList = scoreCodeMap.get(key);
			if (scList != null) {
				js.put("hasEnums", true);
				JSONArray jsArr = new JSONArray();
				js.put("sci", jsArr);
				for (Assessmentscorecode asc : scList) {
					JSONObject scJs = new JSONObject();
					scJs.put("l", asc.getScorecodevalue());
					scJs.put("c", asc.getScorecode());
					jsArr.put(scJs);
				}
			} else {
				js.put("hasEnums", false);
			}
			response.setContentType("application/json");
			String jsonStr = js.toString();
			log.info("jsonStr:" + jsonStr);
			response.getOutputStream().println(jsonStr);
			return null;
		} catch (Exception x) {
			x.printStackTrace();
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public static Map<String, Experiment> toMap(List<Experiment> experiments) {
		Map<String, Experiment> map = new HashMap<String, Experiment>();
		for (Iterator<Experiment> iter = experiments.iterator(); iter.hasNext();) {
			Experiment exp = iter.next();
			map.put(exp.getUniqueid().toString(), exp);
		}
		return map;
	}
}
