package clinical.web.actions;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;

import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.exception.ExpiredSessionException;



/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: BaseAction.java 62 2009-05-29 23:54:50Z bozyurt $
 */

public class BaseAction extends Action {
  protected BaseActionHelper helper;
  public BaseAction() {
    super();
    helper = new BaseActionHelper();
  }


  /**
   *
   * @param request provides request information for Struts controller servlet
   * @param response provides response information for Struts controller servlet
   * @param mapping represents the information that the Struts controller knows about the mapping
   * of a particular request to an instance of a particular <code>Action<code> class
   * @param form a java bean holding the user interface form data
   * @param x an exception raised within the user defined <code>Action</code> to be wrapped via
   * an <code>BaseException</code>
   * @return destination to which the controller, RequestProcessor, might be directed to perform a
   * <code>RequestDispatcher.forward</code> or <code>HttpServletResponse.sendRedirect</code> to,
   * as a result of processing activities of an <code>Action</code> class
   * @throws ServletException
   */

  public ActionForward processExceptions(HttpServletRequest request,
                                           HttpServletResponse response,
       ActionMapping mapping, ActionForm form, Exception x) throws ServletException
  {
    BaseException be = null;
    if (x instanceof BaseException) {
      be = (BaseException) x;
    }else
      be = new BaseException(x);
    return processExceptions(request, response, mapping, form, be);
  }

  /**
   *
   * @param request provides request information for Struts controller servlet
   * @param response provides response information for Struts controller servlet
   * @param mapping represents the information that the Struts controller knows about the mapping
   * of a particular request to an instance of a particular <code>Action<code> class
   * @param form a java bean holding the user interface form data
   * @param be an exception raised within the user defined <code>Action</code>.
   * @return destination to which the controller, RequestProcessor, might be directed to perform a
   * <code>RequestDispatcher.forward</code> or <code>HttpServletResponse.sendRedirect</code> to,
   * as a result of processing activities of an <code>Action</code> class
   * @throws ServletException
   */
  public ActionForward processExceptions(HttpServletRequest request,
                                          HttpServletResponse response,
      ActionMapping mapping, ActionForm form, BaseException be) throws ServletException
  {
    ActionMessages errors = new ActionMessages();
    ActionForward af = helper.processExceptions(request, response, mapping, form, be , errors);
    super.saveMessages(request, errors);
    // to allow a last oppurtunity to the Action class to do cleanup after exception handling
    cleanupAfterException(request, response, mapping, form, be );
    return af;
  }


  public void checkSessionAndUser(HttpServletRequest request) throws ExpiredSessionException {
     helper.checkUser(request);
  }

  public void cleanupAfterException(HttpServletRequest request,
                                          HttpServletResponse response,
      ActionMapping mapping, ActionForm form, BaseException be)
  {}


  /**
   *
   * @param request provides request information for Struts controller servlet
   * @return destination to which the controller, RequestProcessor, might be directed to perform a
   * <code>RequestDispatcher.forward</code> or <code>HttpServletResponse.sendRedirect</code> to,
   * as a result of processing activities of an <code>Action</code> class
   *
   * @throws ExpiredSessionException
   */
  public UserInfo getUserInfo(HttpServletRequest request) throws ExpiredSessionException {
    return helper.getUserInfo(request);
  }
}
