package clinical.web.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.List;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.vo.Experiment;
import clinical.utils.Assertion;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.IRemoteDBServices;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.download.DownloadJob;
import clinical.web.download.FileBundleConfig;
import clinical.web.download.SubjectImageDataBundle;
import clinical.web.exception.ValidationException;
import clinical.web.forms.AsQueryBuilderForm;
import clinical.web.forms.ShoppingCartForm;
import clinical.web.helpers.EmailHelper;
import clinical.web.helpers.ShoppingCartHelper;
import clinical.web.scheduler.JobScheduler;
import clinical.web.vo.ExpSubjectsIDBInfo;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: BatchDownloadAction.java,v 1.1.2.2 2008/07/30 01:15:31 bozyurt
 *          Exp $
 */
public class BatchDownloadAction extends BaseLookupDispatchAction {
	protected Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(BatchDownloadAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.batch.download", "scheduleDownload");
		map.put("button.batch.cancel", "cancel");
		return map;
	}

	public ActionForward cancel(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			getUserInfo(request);
			return mapping.findForward(Constants.FORWARD_CANCEL);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward scheduleDownload(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		try {
			log.info("in doBatchQuery");
			UserInfo ui = getUserInfo(request);
			ShoppingCartForm scForm = (ShoppingCartForm) form;
			HttpSession session = request.getSession(false);

			String bundleName = scForm.getBundleName();
			if (bundleName == null || bundleName.trim().length() == 0) {
				bundleName = "data_download";
			}

			// get run types to bundle
			Map<String, ExpSubjectsIDBInfo> esidbMap = scForm.getEsidbMap();
			Map<ExpSubjectsIDBInfo, Set<String>> esidb2RTMap = new HashMap<ExpSubjectsIDBInfo, Set<String>>(
					7);
			int count = 0;
			for (Enumeration<?> it = request.getParameterNames(); it
					.hasMoreElements();) {
				String pn = (String) it.nextElement();
				if (pn.endsWith("_runType")) {
					String[] runTypes = request.getParameterValues(pn);
					String key = pn.substring(0, pn.lastIndexOf('_'));
					for (ExpSubjectsIDBInfo esidb : esidbMap.values()) {
						if (esidb.getKey().equals(key)) {
							Set<String> rtSet = esidb2RTMap.get(esidb);
							if (rtSet == null) {
								rtSet = new HashSet<String>(3);
								esidb2RTMap.put(esidb, rtSet);
							}
							for (int i = 0; i < runTypes.length; i++) {
								++count;
							   rtSet.add(runTypes[i]);
							}
						}
					}
				}
			}
			if (count == 0)
				throw new ValidationException(
						"At least one run type needs to be checked!");
			if (count > 2)
				throw new ValidationException(
						"At most two run types are allowed to be downloaded in batch!");

			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			ISecurityService secService = ServiceFactory.getSecurityService();
			String curSiteID = secService.findSiteIDByDbID(dbID);
			Assertion.assertNotNull(curSiteID);

			IDBCache dbCache = ServiceFactory.getDBCache(dbID);
			List<Experiment> expList = dbCache.getExperiments(ui, false);
			Map<String, Experiment> expMap = toMap(curSiteID, expList);

			Set<String> remoteSiteIDSet = new HashSet<String>(17);

			List<SubjectImageDataBundle> caSIDBList = new ArrayList<SubjectImageDataBundle>();

			for (Map.Entry<ExpSubjectsIDBInfo, Set<String>> entry : esidb2RTMap
					.entrySet()) {
				ExpSubjectsIDBInfo esidb = entry.getKey();
				Set<String> runTypeSet = entry.getValue();
				esidb.leaveOnlyRunTypes(runTypeSet);
				remoteSiteIDSet.addAll(esidb.getRemoteSiteIDSet(curSiteID));
				caSIDBList.addAll(esidb.getAllSIDBs());
			}

			if (!remoteSiteIDSet.isEmpty()) {
				IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();
				for (String siteID : remoteSiteIDSet) {
					Map<String, Experiment> map = rds.getAllExperiments(siteID);
					for (Experiment e : map.values()) {
						expMap.put(siteID + "_" + e.getName(), e);
					}
				}
			}

			String id = String.valueOf(System.currentTimeMillis());
			String description = "download named '" + bundleName + "'";

			IAppConfigService configService = ServiceFactory
					.getAppConfigService();

			String cacheRoot = configService
					.getParamValue("download.cacheroot");
			if (cacheRoot == null || cacheRoot.trim().length() == 0) {
				throw new ValidationException(
						"System Setup Problem: A valid cache root directory needs to be supplied "
								+ "during system setup with property download.cacheroot:! ");
			}

			File cacheDir = new File(cacheRoot, id);
			cacheDir.mkdirs();

			List<ExpSubjectsIDBInfo> esidbList = new ArrayList<ExpSubjectsIDBInfo>(
					esidb2RTMap.keySet());
			FileBundleConfig fbc = ShoppingCartHelper.prepareFileBundleConfig(
					esidbList, bundleName, cacheDir.getAbsolutePath(), expMap);

			DownloadJob job = new DownloadJob(id, ui, description, fbc);
			job.setDbID(dbID);

			if (scForm.isSupportEmail() && scForm.isNotifyByEmail()
					&& GenUtils.isNotEmpty(scForm.getEmail())
					&& GenUtils.isValidEmail(scForm.getEmail())) {

				log.info("will notify by email!");
				String emailHost = configService.getParamValue("email.host");
				String emailUser = configService.getParamValue("email.user");
				String emailPwd = configService.getParamValue("email.pwd");
				String emailFrom = configService.getParamValue("email.from");
				EmailHelper emailHelper = new EmailHelper(emailHost, emailUser,
						emailPwd, emailFrom);
				emailHelper.setToUser(scForm.getEmail());
				job.setEmailHelper(emailHelper);
				scForm.setWillNotify(true);
			}

			// handle assessments (get all assessments for each subject in
			// experiments)
			// only for assessments known to the primary database.

			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) session
					.getAttribute(Constants.ASQUERYFORM_KEY);

			List<AssessmentSelectionInfo> asiList = queryForm.getAssessments();
			job.setFilteredAsiList(asiList);
			job.setCaSIDBList(caSIDBList);

			// schedule job
			JobScheduler scheduler = JobScheduler.getInstance();
			scheduler.addJob(job);
			scForm.setScheduledJobID(id);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	protected static Map<String, Experiment> toMap(String siteID,
			List<Experiment> expList) {
		Map<String, Experiment> map = new HashMap<String, Experiment>();
		for (Iterator<Experiment> iter = expList.iterator(); iter.hasNext();) {
			Experiment exp = iter.next();
			map.put(siteID + "_" + exp.getName(), exp);
		}
		return map;
	}
}
