package clinical.web.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.web.Constants;
import clinical.web.ServiceFactory;
import clinical.web.common.ISecurityService;
import clinical.web.common.security.User;
import clinical.web.forms.LoginHandlerForm;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: LoginHandlerAction.java 62 2009-05-29 23:54:50Z bozyurt $
 */


public class LoginHandlerAction extends BaseAction {
  private Log log = LogFactory.getLog(LoginHandlerAction.class);

  public LoginHandlerAction() {}

  public ActionForward execute(ActionMapping mapping,
                              ActionForm form,
                              HttpServletRequest request,
                              HttpServletResponse response) throws Exception
 {
   try {
     LoginHandlerForm lhForm = (LoginHandlerForm) form;
     // check if we got srb params
     /** @todo needs to enhance beyond srbUser checking. More correclty, need to use LDAP based security credentials checking */
     if ( lhForm.getSrbUser() == null) {
        throw new Exception("The user cannot be authenticated!");
     }


     ISecurityService secScervice = ServiceFactory.getSecurityService();
     // needs the dbID passed from the BIRN portal
     String dbID = secScervice.getDefaultDBID();
     User theUser = secScervice.getRestrictedUser(dbID);

/*
     request.setAttribute("username", theUser.getName() );
     request.setAttribute("password", theUser.getPwd() );
     request.setAttribute("dbID", dbID );
*/

     lhForm.setDbID(dbID);
     lhForm.setUsername( theUser.getName() );
     lhForm.setPassword(theUser.getPwd());

     log.info("userName=" + theUser.getName() + " dbID=" + dbID);
     return mapping.findForward(Constants.SUCCESS);
   } catch(Exception x) {
     return processExceptions(request, response, mapping, form, x);
   }

 }

}