package clinical.web.actions;

import java.io.File;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONObject;

import clinical.web.Constants;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.download.ImageSeriesDataInfo;
import clinical.web.forms.SubjectVisitManagementForm;
import clinical.web.helpers.SegmentFormInfo;
import clinical.web.services.IDownloadJobService;
import clinical.web.services.SecurityService;
import clinical.web.vo.StudySegment;
import clinical.web.vo.VisitSegment;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class SegmentImageSeriesViewerDataAction extends BaseAction {
	private Log log = LogFactory
			.getLog(SegmentImageSeriesViewerDataAction.class);

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("execute");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) session
					.getAttribute(Constants.SUBVISITMANAGEMENT_FORM_KEY);

			SecurityService ss = (SecurityService) ServiceFactory
					.getSecurityService();
			String siteID = ss.getSiteID(dbID);
			// int visitID = GenUtils.toInt(request.getParameter("visitID"), -1);
			// int segID = GenUtils.toInt(request.getParameter("segID"), -1);
			SegmentFormInfo sfi = svmForm.getCurrentSegment();

			ImageSeriesDataInfo isdi = null;
			File[] jpegFiles = null;
			String cacheRoot = ImageSeriesViewHelper.REL_VIEWER_IMAGES_PATH;
			cacheRoot = session.getServletContext().getRealPath(cacheRoot);
			new File(cacheRoot).mkdirs();

			if (svmForm.getCurrentStudy() != null) {
				StudySegment studySeg = sfi.getStudySegment();
				if (studySeg != null) {
					IDownloadJobService djs = ServiceFactory.getDownloadJobService();
					isdi = studySeg.getIsdi();

					jpegFiles = djs.downloadAndPrepareImageSeries(isdi, cacheRoot,
							ui);
				}
			} else {
				VisitSegment vs = sfi.getVisitSegment();
				if (vs != null) {
					IDownloadJobService djs = ServiceFactory.getDownloadJobService();
					isdi = vs.getIsdi();

					jpegFiles = djs.downloadAndPrepareImageSeries(isdi, cacheRoot,
							ui);
				}
			}
			JSONObject js = ImageSeriesViewHelper.prepImagePreviewComObject(
					siteID, isdi, jpegFiles);
			response.setContentType("application/json");
			String jsonStr = js.toString();
			log.info("jsonStr:" + jsonStr);
			response.getOutputStream().println(jsonStr);
			return null;

		} catch (Exception x) {
			log.error("execute", x);
			JSONObject js = new JSONObject();
			JSONArray jsArr = new JSONArray();
			js.put("jpegs", jsArr);
			response.setContentType("application/json");
			String jsonStr = js.toString();
			response.getOutputStream().println(jsonStr);
		}

		return null;
	}
}
