package clinical.web.actions;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.utils.ValidationUtils;
import clinical.web.Constants;
import clinical.web.IExperimentManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.forms.ExperimentManagementForm;
import clinical.web.vo.StudyGroupInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: StudyGroupManagementAction.java,v 1.3 2006/01/24 21:09:25
 *          bozyurt Exp $
 */
public class StudyGroupManagementAction extends BaseLookupDispatchAction {
	protected Map<String, String> map = new HashMap<String, String>(7);

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.add_studygroup", "addStudyGroup");
		return map;
	}

	public StudyGroupManagementAction() {
	}

	/**
	 * adds a new study group for the current experiment
	 * 
	 * @param mapping
	 * @param form
	 * @param request
	 * @param response
	 * @return
	 * @throws java.lang.Exception
	 */
	public ActionForward addStudyGroup(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		IExperimentManagement iem = null;
		ExperimentManagementForm emForm = (ExperimentManagementForm) form;

		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			iem = ServiceFactory.getExperimentManagement(dbID);

			StudyGroupInfo sgi = emForm.getStudyGroupInfo();
			ValidationUtils.notEmpty("Study Group Name", sgi.getName());
			iem.addStudyGroup(ui, sgi);
			sgi.setSaved(true);

			ExperimentManagementHelper.prepareEnrolledSubjectStudyGroups(dbID,
					ui, emForm.getExperimentInfo().getId(), emForm);
		} catch (Exception x) {
			log.error("updateExperiment", x);
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward(Constants.SUCCESS);
	}
}
