package clinical.web.common;

import java.util.*;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentMapping.java 62 2009-05-29 23:54:50Z bozyurt $
 */

public class AssessmentMapping {
	protected String name;
	protected int assessmentID;
	protected int mappedAssessmentID;
	/**
	 * The first database ID The assessment mapping is done between a pair of
	 * databases.
	 */
	protected String firstDB;
	protected String secondDB;
	protected Map<String, ScoreMap> scoreMapMap = new HashMap<String, ScoreMap>(
			11);

	public AssessmentMapping(String name, int asID) {
		this(name, asID, null, null);
	}

	public AssessmentMapping(String name, int asID, String firstDB,
			String secondDB) {
		this.name = name;
		this.assessmentID = asID;
		this.firstDB = firstDB;
		this.secondDB = secondDB;
	}

	public ScoreMap addScoreMap(String scoreName, String otherScoreName,
			int otherAsID) {
		ScoreMap scoreMap = new ScoreMap(scoreName, otherScoreName, otherAsID);
		scoreMapMap.put(scoreName, scoreMap);
		return scoreMap;
	}

	public ScoreMap getMappedScoreName(String scoreName) {
		return scoreMapMap.get(scoreName);
	}

	public Collection<ScoreMap> getScoreMaps() {
		return scoreMapMap.values();
	}

	// ---------------------- setters --------------
	public void setName(String newName) {
		this.name = newName;
	}

	public void setAssessmentID(int newAssessmentID) {
		this.assessmentID = newAssessmentID;
	}

	public void setMappedAssessmentID(int newMappedAssessmentID) {
		this.mappedAssessmentID = newMappedAssessmentID;
	}

	public void setFirstDB(String newFirstDB) {
		this.firstDB = newFirstDB;
	}

	public void setSecondDB(String newSecondDB) {
		this.secondDB = newSecondDB;
	}

	// ---------------------- getters --------------
	public String getName() {
		return this.name;
	}

	public int getAssessmentID() {
		return this.assessmentID;
	}

	public int getMappedAssessmentID() {
		return this.mappedAssessmentID;
	}

	public String getFirstDB() {
		return this.firstDB;
	}

	public String getSecondDB() {
		return this.secondDB;
	}

	public static class ScoreMap {
		String name;
		String mappedName;
		int mappedAsID;
		TypeMap typeMap;

		public ScoreMap(String name, String mappedName, int mappedAsID) {
			this.name = name;
			this.mappedAsID = mappedAsID;
			this.mappedName = mappedName;
		}

		public void setTypeMap(TypeMap tmap) {
			this.typeMap = tmap;
		}

		public String getName() {
			return this.name;
		}

		public String getMappedName() {
			return this.mappedName;
		}

		public int getMappedAsID() {
			return this.mappedAsID;
		}

		public TypeMap getTypeMap() {
			return typeMap;
		}

		public String toString() {
			StringBuffer sb = new StringBuffer(128);
			sb.append("ScoreMap::[");
			sb.append("name=").append(name).append(", mappedName=").append(
					mappedName);
			sb.append(", mappedAsID=").append(mappedAsID);
			if (typeMap != null) {
				sb.append("\n").append(typeMap.toString());
			}
			sb.append(']');
			return sb.toString();
		}
	}

	public static class TypeMap {
		String firstDbType;
		String secondDbType;
		Map<Object, Object> valueMap = new HashMap<Object, Object>(5);

		public TypeMap(String firstDbType, String secondDbType) {
			this.firstDbType = firstDbType;
			this.secondDbType = secondDbType;
		}

		public Object getSecondDBValue(Object firstDBValue) {
			return valueMap.get(firstDBValue);
		}

		public void addValueMap(Object firstDBValue, Object secondDBValue) {
			valueMap.put(firstDBValue, secondDBValue);
		}

		public String getFirstDbType() {
			return this.firstDbType;
		}

		public String getSecondDbType() {
			return secondDbType;
		}

		public String toString() {
			StringBuffer sb = new StringBuffer(128);
			sb.append("TypeMap::[");
			sb.append("firstDBType=").append(firstDbType).append(
					", secondDbType=").append(secondDbType);
			for (Map.Entry<Object,Object> entry : valueMap.entrySet()) {
				sb.append("\n\tfirstDBValue=").append(entry.getKey());
				sb.append(", secondDBValue=").append(entry.getValue());
			}
			sb.append(']');
			return sb.toString();
		}

	}

	public int hashCode() {
		StringBuffer sb = new StringBuffer();
		sb.append(assessmentID).append(name).append(firstDB).append('_')
				.append(secondDB);
		return sb.toString().hashCode();
	}

	public boolean equals(Object other) {
		if (other == this) {
			return true;
		}
		if (!(other instanceof AssessmentMapping)) {
			return false;
		}
		AssessmentMapping that = (AssessmentMapping) other;
		return this.assessmentID == that.assessmentID && this.name == that.name
				&& this.firstDB == that.firstDB
				&& this.secondDB == that.secondDB;
	}

	public String toString() {
		StringBuffer sb = new StringBuffer(128);
		sb.append("AssessmentMapping::[");
		sb.append("name=").append(name).append(", firstDB=").append(firstDB);
		sb.append(",secondDB=").append(secondDB)
				.append(", mappedAssessmentID=").append(mappedAssessmentID);
		sb.append("\n");
		for (Iterator<ScoreMap> iter = scoreMapMap.values().iterator(); iter
				.hasNext();) {
			ScoreMap sm = iter.next();
			sb.append(sm.toString()).append("\n");
		}
		sb.append(']');
		return sb.toString();
	}
}