package clinical.web.common.query;

import java.io.Serializable;


/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: UnaryOperator.java 62 2009-05-29 23:54:50Z bozyurt $
 */

public class UnaryOperator extends Operator implements Serializable {
	private static final long serialVersionUID = 1L;

	public UnaryOperator(SearchPredicate predicate, int logicalOp) {
		this.predicate = predicate;
		this.logicalOp = logicalOp;
	}

	public UnaryOperator() {
	}

	public boolean isEmpty() {
		return predicate == null;
	}

	public void accept(ISearchCriteriaVisitor visitor) throws Exception {
		visitor.visit(this);
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("UnaryOperator::[");
		sb.append("predicate:").append(predicate.toString());
		sb.append(",logicalOp=").append(logicalOp);
		sb.append(']');
		return sb.toString();
	}
}
