package clinical.web.download;

import java.io.File;

import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Untar;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: Unpacker.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class Unpacker extends Untar {
   protected String destDir;

   public Unpacker(String archiveFile, String destDir) {
      super();
      this.destDir = destDir;
      setProject(new Project());
      setTaskName("untar");
      setSrc( new File( archiveFile) );
      setDest( new File(destDir));
      String compressionScheme = "none";
      if (archiveFile.endsWith(".tgz") || archiveFile.endsWith(".tar.gz")) {
         compressionScheme = "gzip";
      } else if ( archiveFile.endsWith(".bz2")) {
         compressionScheme = "bzip2";
      }
      UntarCompressionMethod utcm = new UntarCompressionMethod();
      utcm.setValue(compressionScheme);
      setCompression(utcm);      
   }
   
   public void unpack() {
      super.execute();
   }

}
