package clinical.web.forms;

import java.util.*;

import org.apache.struts.util.*;

/**
 * 
 * Helper class for assessment selection drop down in the segment management
 * page
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentSelector.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class AssessmentSelector {
	List<LabelValueBean> assessmentsToEdit;
	int selectedAssessmentIdx;

	public AssessmentSelector(List<String> asNames) {
		assessmentsToEdit = new ArrayList<LabelValueBean>(asNames.size());
		boolean first = true;
		int idx = 0;

		for (String asName : asNames) {
			LabelValueBean lvb = new LabelValueBean(asName, String.valueOf(idx));
			assessmentsToEdit.add(lvb);
			if (first) {
				selectedAssessmentIdx = idx;
				first = false;
			}
			++idx;
		}
	}

	public Collection<LabelValueBean> getAssessmentsToEditList() {
		return this.assessmentsToEdit;
	}

	public String getAssessmentsToEdit(int idx) {
		LabelValueBean lvb = assessmentsToEdit.get(idx);
		return lvb.getLabel();
	}

	public void setSelectedAssessmentIdx(int newSelectedAssessmentIdx) {
		this.selectedAssessmentIdx = newSelectedAssessmentIdx;
	}

	public int getSelectedAssessmentIdx() {
		return this.selectedAssessmentIdx;
	}

}
