package clinical.web.forms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

import clinical.web.helpers.CombinedScoreSelector;
import clinical.web.helpers.DescriptiveStats;
import clinical.web.helpers.RegressionInfo;
import clinical.web.helpers.ScoresSelector;
import clinical.web.helpers.SingleScoreSelector;
import clinical.web.helpers.StatsOptionSelector;
import clinical.web.helpers.StatsResultsData;
import clinical.web.vo.ScoreMetaData;

/**
 * @author I. Burak Ozyurt
 * @version $Id: StatisticsForm.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class StatisticsForm extends ActionForm {
	Map<String, ScoreMetaData> smdMap;
	ScoresSelector contScoresSelector;
	SingleScoreSelector discreteScoreSelector;
	StatsOptionSelector statsOptionSelector;
	boolean msd;
	boolean plotHistogram;
	boolean normTest;
	boolean plotBarGraph;
	boolean plotQQ;
	List<DescriptiveStats> descStatsList;

	// for bivariate
	CombinedScoreSelector bv1ScoreSelector;
	CombinedScoreSelector bv2ScoreSelector;
	SingleScoreSelector groupByVarSelector;
	boolean plotOLS;
	String olsChartImageFile;
	Collection<RegressionInfo> regressionInfos;
	String imageMapInfo;
	String scatterDataInfoJSON;


	Collection<StatsResultsData> statResultsDataList = new ArrayList<StatsResultsData>();
	String barChartImageFile;

	private static final long serialVersionUID = 7496131970243166799L;

	public StatisticsForm() {
	}

	public void setContScoresSelector(ScoresSelector newContScoresSelector) {
		this.contScoresSelector = newContScoresSelector;
	}

	public void setDiscreteScoreSelector(
			SingleScoreSelector newDiscreteScoreSelector) {
		this.discreteScoreSelector = newDiscreteScoreSelector;
	}

	public void setMsd(boolean newMsd) {
		this.msd = newMsd;
	}

	public void setPlotHistogram(boolean newPlotHistogram) {
		this.plotHistogram = newPlotHistogram;
	}

	public void setNormTest(boolean newNormTest) {
		this.normTest = newNormTest;
	}

	public void setStatsOptionSelector(
			StatsOptionSelector newStatsOptionSelector) {
		this.statsOptionSelector = newStatsOptionSelector;
	}

	// ---------------------- getters --------------

	public ScoresSelector getContScoresSelector() {
		return this.contScoresSelector;
	}

	public SingleScoreSelector getDiscreteScoreSelector() {
		return this.discreteScoreSelector;
	}

	public StatsOptionSelector getStatsOptionSelector() {
		return this.statsOptionSelector;
	}

	public boolean isMsd() {
		return this.msd;
	}

	public boolean isPlotHistogram() {
		return this.plotHistogram;
	}

	public boolean isNormTest() {
		return this.normTest;
	}

	public void addStatResultsData(StatsResultsData srd) {
		statResultsDataList.add(srd);
	}

	public Collection<StatsResultsData> getStatResultsDataList() {
		return this.statResultsDataList;
	}

	public boolean isPlotBarGraph() {
		return plotBarGraph;
	}

	public void setPlotBarGraph(boolean plotBarGraph) {
		this.plotBarGraph = plotBarGraph;
	}

	public String getBarChartImageFile() {
		return barChartImageFile;
	}

	public void setBarChartImageFile(String barChartImageFile) {
		this.barChartImageFile = barChartImageFile;
	}

	public CombinedScoreSelector getBv1ScoreSelector() {
		return bv1ScoreSelector;
	}

	public void setBv1ScoreSelector(CombinedScoreSelector bv1ScoreSelector) {
		this.bv1ScoreSelector = bv1ScoreSelector;
	}

	public CombinedScoreSelector getBv2ScoreSelector() {
		return bv2ScoreSelector;
	}

	public void setBv2ScoreSelector(CombinedScoreSelector bv2ScoreSelector) {
		this.bv2ScoreSelector = bv2ScoreSelector;
	}

	public SingleScoreSelector getGroupByVarSelector() {
		return groupByVarSelector;
	}

	public void setGroupByVarSelector(SingleScoreSelector groupByVarSelector) {
		this.groupByVarSelector = groupByVarSelector;
	}

	public String getOlsChartImageFile() {
		return olsChartImageFile;
	}

	public void setOlsChartImageFile(String olsChartImageFile) {
		this.olsChartImageFile = olsChartImageFile;
	}

	public boolean isPlotOLS() {
		return plotOLS;
	}

	public void setPlotOLS(boolean plotOLS) {
		this.plotOLS = plotOLS;
	}

	public void setStatResultsDataList(
			Collection<StatsResultsData> statResultsDataList) {
		this.statResultsDataList = statResultsDataList;
	}

	public void reset(ActionMapping mapping, HttpServletRequest request) {
		setMsd(false);
		setPlotHistogram(false);
		setNormTest(false);
		setPlotBarGraph(false);
		setPlotOLS(false);
		setPlotQQ(false);
		if (contScoresSelector != null) {
			contScoresSelector.setSelectedScores(new String[0]);
		}
	}

	public ActionErrors validate(ActionMapping mapping,
			HttpServletRequest request) {
		ActionErrors errors = new ActionErrors();
		// TODO
		return errors;
	}

	public Collection<RegressionInfo> getRegressionInfos() {
		return regressionInfos;
	}

	public void setRegressionInfos(Collection<RegressionInfo> regressionInfos) {
		this.regressionInfos = regressionInfos;
	}

	public boolean isPlotQQ() {
		return plotQQ;
	}

	public void setPlotQQ(boolean plotQQ) {
		this.plotQQ = plotQQ;
	}

	public List<DescriptiveStats> getDescStatsList() {
		return descStatsList;
	}

	public void setDescStatsList(List<DescriptiveStats> descStatsList) {
		this.descStatsList = descStatsList;
	}

	public void setImageMapInfo(String imageMapInfo) {
		this.imageMapInfo = imageMapInfo;
	}

	public String getImageMapInfo() {
		return imageMapInfo;
	}

	public String getScatterDataInfoJSON() {
		return scatterDataInfoJSON;
	}

	public void setScatterDataInfoJSON(String scatterDataInfoJSON) {
		this.scatterDataInfoJSON = scatterDataInfoJSON;
	}

	public Map<String, ScoreMetaData> getSmdMap() {
		return smdMap;
	}

	public void setSmdMap(Map<String, ScoreMetaData> smdMap) {
		this.smdMap = smdMap;
	}

}
