package clinical.web.forms;

import java.util.List;

import org.apache.struts.action.ActionForm;

import clinical.web.common.security.DBConfig;
import clinical.web.common.security.Privilege;
import clinical.web.helpers.DBConfigSelector;

/**
 * @author I. Burak Ozyurt
 * @version $Id: UserAndDBConfigForm.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class UserAndDBConfigForm extends ActionForm {
	protected List<DBConfig> dbConfigs;
	protected DBConfigSelector dbConfigSelector;
	protected DBConfig curDBConfig;
	protected List<Privilege> privileges;
	/**
	 * scratch variable used to indicate the name of the current web user for
	 * subsequent calls to the form object
	 */
	protected String curWebUser;	
	protected String curDBUser;
	
	/**
	 * either <code>ADD_OP</code> or <code>EDIT_OP</code>
	 */
	protected String opType;
	
	/** current database id */
	protected String curDB;
	

	public final static String ADD_OP = "add";
	public final static String EDIT_OP = "edit";
	
	private static final long serialVersionUID = 1L;

	public UserAndDBConfigForm() {
		super();
	}

	public List<DBConfig> getDbConfigs() {
		return dbConfigs;
	}

	public DBConfigSelector getDbConfigSelector() {
		return dbConfigSelector;
	}

	public DBConfig getCurDBConfig() {
		return curDBConfig;
	}

	public void setDbConfigs(List<DBConfig> dbConfigs) {
		this.dbConfigs = dbConfigs;
	}

	public void setDbConfigSelector(DBConfigSelector dbConfigSelector) {
		this.dbConfigSelector = dbConfigSelector;
	}

	public void setCurDBConfig(DBConfig curDBConfig) {
		this.curDBConfig = curDBConfig;
	}

	public List<Privilege> getPrivileges() {
		return privileges;
	}

	public void setPrivileges(List<Privilege> privileges) {
		this.privileges = privileges;
	}

	public List<Privilege> getRemainingPrivileges() {
		return null;
	}

	public String getCurWebUser() {
		return curWebUser;
	}

	public void setCurWebUser(String curWebUser) {
		this.curWebUser = curWebUser;
	}

	public String getOpType() {
		return opType;
	}

	public void setOpType(String opType) {
		this.opType = opType;
	}

	public String getCurDBUser() {
		return curDBUser;
	}

	public void setCurDBUser(String curDBUser) {
		this.curDBUser = curDBUser;
	}

	public String getCurDB() {
		return curDB;
	}

	public void setCurDB(String curDB) {
		this.curDB = curDB;
	}

}
