package clinical.web.game.forms;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
/**
  *
  * @version $Id: ASIForm.java 62 2009-05-29 23:54:50Z bozyurt $
  * @author Generated by Clinical Assessment Layout Manager (CALM)
  */

public class ASIForm extends ActionForm {

    private String ASIIndex= "";
    private String anxiousness= "";
    private String fear= "";
    private String panic= "";
    private String mentalDisintegration= "";
    private String apprehension= "";
    private String tremors= "";
    private String bodyAchesAndPains= "";
    private String easyFatiguabilityWeakness= "";
    private String restlessness= "";
    private String palpitation= "";
    private String dizziness= "";
    private String faintness= "";
    private String dyspnea= "";
    private String paresthesias= "";
    private String nauseaAndVomiting= "";
    private String urinaryFrequency= "";
    private String sweating= "";
    private String faceFlushing= "";
    private String insomnia= "";
    private String nightmares= "";
    private String date = "";
    private String time = "";
    private String informantid = "";
    private String informantrelation = "";
    private DynamicDropDownSelector clinicalrater;

    // variables standard for each generated Assessment Struts Form Bean
    private String assessmentID;
    private String subjectID;
    private String experimentID;
    private String visitID;
    private String segmentID;
    private int currentPageIdx = 1;
    private String selectedQuestion = "";
    private String skippedQuestions = "";
    private String dataClassificationForSkipped = "";

    private static Map pageQuestionsMap;
    private static Map variableMap = null;
    private static Map mandatoryFieldMetaDataMap = null;

    public ASIForm() {
    }

    public String getASIIndex() {  return this.ASIIndex; }
    public String getAnxiousness() {  return this.anxiousness; }
    public String getFear() {  return this.fear; }
    public String getPanic() {  return this.panic; }
    public String getMentalDisintegration() {  return this.mentalDisintegration; }
    public String getApprehension() {  return this.apprehension; }
    public String getTremors() {  return this.tremors; }
    public String getBodyAchesAndPains() {  return this.bodyAchesAndPains; }
    public String getEasyFatiguabilityWeakness() {  return this.easyFatiguabilityWeakness; }
    public String getRestlessness() {  return this.restlessness; }
    public String getPalpitation() {  return this.palpitation; }
    public String getDizziness() {  return this.dizziness; }
    public String getFaintness() {  return this.faintness; }
    public String getDyspnea() {  return this.dyspnea; }
    public String getParesthesias() {  return this.paresthesias; }
    public String getNauseaAndVomiting() {  return this.nauseaAndVomiting; }
    public String getUrinaryFrequency() {  return this.urinaryFrequency; }
    public String getSweating() {  return this.sweating; }
    public String getFaceFlushing() {  return this.faceFlushing; }
    public String getInsomnia() {  return this.insomnia; }
    public String getNightmares() {  return this.nightmares; }
    public String getDate() {  return this.date; }
    public String getTime() {  return this.time; }
    public String getInformantid() {  return this.informantid; }
    public String getInformantrelation() {  return this.informantrelation; }
    public DynamicDropDownSelector getClinicalrater() {  return this.clinicalrater; }

    public void setASIIndex(String newValue) {  this.ASIIndex = newValue; }
    public void setAnxiousness(String newValue) {  this.anxiousness = newValue; }
    public void setFear(String newValue) {  this.fear = newValue; }
    public void setPanic(String newValue) {  this.panic = newValue; }
    public void setMentalDisintegration(String newValue) {  this.mentalDisintegration = newValue; }
    public void setApprehension(String newValue) {  this.apprehension = newValue; }
    public void setTremors(String newValue) {  this.tremors = newValue; }
    public void setBodyAchesAndPains(String newValue) {  this.bodyAchesAndPains = newValue; }
    public void setEasyFatiguabilityWeakness(String newValue) {  this.easyFatiguabilityWeakness = newValue; }
    public void setRestlessness(String newValue) {  this.restlessness = newValue; }
    public void setPalpitation(String newValue) {  this.palpitation = newValue; }
    public void setDizziness(String newValue) {  this.dizziness = newValue; }
    public void setFaintness(String newValue) {  this.faintness = newValue; }
    public void setDyspnea(String newValue) {  this.dyspnea = newValue; }
    public void setParesthesias(String newValue) {  this.paresthesias = newValue; }
    public void setNauseaAndVomiting(String newValue) {  this.nauseaAndVomiting = newValue; }
    public void setUrinaryFrequency(String newValue) {  this.urinaryFrequency = newValue; }
    public void setSweating(String newValue) {  this.sweating = newValue; }
    public void setFaceFlushing(String newValue) {  this.faceFlushing = newValue; }
    public void setInsomnia(String newValue) {  this.insomnia = newValue; }
    public void setNightmares(String newValue) {  this.nightmares = newValue; }
    public void setDate(String newValue) {  this.date = newValue; }
    public void setTime(String newValue) {  this.time = newValue; }
    public void setInformantid(String newValue) {  this.informantid = newValue; }
    public void setInformantrelation(String newValue) {  this.informantrelation = newValue; }
    public void setClinicalrater(DynamicDropDownSelector newValue) {  this.clinicalrater = newValue; }

                    
                    
                    


    public String getAssessmentID() {  return this.assessmentID; }
    public String getSubjectID() {  return this.subjectID; }
    public String getExperimentID() {  return this.experimentID; }
    public String getVisitID() {  return this.visitID; }
    public String getSegmentID() {  return this.segmentID; }
    public int getCurrentPageIdx() {  return this.currentPageIdx; }
    public String getSelectedQuestion() {  return this.selectedQuestion; }
    public String getSkippedQuestions() {  return this.skippedQuestions; }
    public String getDataClassificationForSkipped() {  return this.dataClassificationForSkipped; }

    public void setAssessmentID(String newValue) {  this.assessmentID = newValue; }
    public void setSubjectID(String newValue) {  this.subjectID = newValue; }
    public void setExperimentID(String newValue) {  this.experimentID = newValue; }
    public void setVisitID(String newValue) {  this.visitID = newValue; }
    public void setSegmentID(String newValue) {  this.segmentID = newValue; }
    public void setCurrentPageIdx(int newValue) {  this.currentPageIdx = newValue; }
    public void setSelectedQuestion(String newValue) {  this.selectedQuestion = newValue; }
    public void setSkippedQuestions(String newValue) {  this.skippedQuestions = newValue; }
    public void setDataClassificationForSkipped(String newValue) {  this.dataClassificationForSkipped = newValue; }

    
public static class PageVariableInfo {
      int pageNumber;
      String formVarName;
      String dbVarName;
      Map metaDataMap;
      public PageVariableInfo(int pageNumber, String formVarName, String dbVarName) {
        this.pageNumber = pageNumber;
        this.formVarName = formVarName;
        this.dbVarName = dbVarName;
      }

      public int getPageNumber() { return this.pageNumber; }
      public String getFormVarName() { return this.formVarName; }
      public String getDbVarName() { return this.dbVarName; }
      public void addMetaData(String name, String value) {
        if (metaDataMap == null) {
          metaDataMap = new HashMap(3);
        }
        metaDataMap.put(name, value);
      }
      public Map getMetaDataMap() { return metaDataMap; }
    }

    private final static String assessmentName = "Anxiety Status Inventory (ASI)";

    public static String getAssessmentName() { return assessmentName; }

    public static Map getVariableMap() {
      synchronized(ASIForm.class) {
        if (variableMap == null) {
      variableMap = new LinkedHashMap();
      PageVariableInfo pvi = null;

          variableMap.put("ASI index", pvi = new PageVariableInfo(2,"ASIIndex","ASI index") );
          variableMap.put("anxiousness", pvi = new PageVariableInfo(2,"anxiousness","anxiousness") );
          variableMap.put("fear", pvi = new PageVariableInfo(2,"fear","fear") );
          variableMap.put("panic", pvi = new PageVariableInfo(2,"panic","panic") );
          variableMap.put("mental disintegration", pvi = new PageVariableInfo(2,"mentalDisintegration","mental disintegration") );
          variableMap.put("apprehension", pvi = new PageVariableInfo(2,"apprehension","apprehension") );
          variableMap.put("tremors", pvi = new PageVariableInfo(2,"tremors","tremors") );
          variableMap.put("body aches and pains", pvi = new PageVariableInfo(2,"bodyAchesAndPains","body aches and pains") );
          variableMap.put("easy fatiguability weakness", pvi = new PageVariableInfo(2,"easyFatiguabilityWeakness","easy fatiguability weakness") );
          variableMap.put("restlessness", pvi = new PageVariableInfo(2,"restlessness","restlessness") );
          variableMap.put("palpitation", pvi = new PageVariableInfo(2,"palpitation","palpitation") );
          variableMap.put("dizziness", pvi = new PageVariableInfo(2,"dizziness","dizziness") );
          variableMap.put("faintness", pvi = new PageVariableInfo(2,"faintness","faintness") );
          variableMap.put("dyspnea", pvi = new PageVariableInfo(2,"dyspnea","dyspnea") );
          variableMap.put("paresthesias", pvi = new PageVariableInfo(2,"paresthesias","paresthesias") );
          variableMap.put("nausea and vomiting", pvi = new PageVariableInfo(2,"nauseaAndVomiting","nausea and vomiting") );
          variableMap.put("urinary frequency", pvi = new PageVariableInfo(2,"urinaryFrequency","urinary frequency") );
          variableMap.put("sweating", pvi = new PageVariableInfo(2,"sweating","sweating") );
          variableMap.put("face flushing", pvi = new PageVariableInfo(2,"faceFlushing","face flushing") );
          variableMap.put("insomnia", pvi = new PageVariableInfo(2,"insomnia","insomnia") );
          variableMap.put("nightmares", pvi = new PageVariableInfo(2,"nightmares","nightmares") );
        }
      }
      return variableMap;
    }
    public static Map getMandatoryFieldMetaDataMap() {
      if (mandatoryFieldMetaDataMap == null) {
        mandatoryFieldMetaDataMap = new HashMap(3);
        Map mdMap = new HashMap(3);
        mandatoryFieldMetaDataMap.put("clinicalrater",mdMap);
        mdMap.put("query","select a.name from nc_databaseuser a, nc_userclass b where a.userclass = b.uniqueid and b.name = 'researcher'");
      }
      return mandatoryFieldMetaDataMap;
    }


 public static class PageQuestionInfo {
    int pageNumber;
    int questionNumber;
    String type;
    int minAnswer;
    int maxAnswer;
    List scoreNames = new LinkedList();
    Map scoreNameIDMAp = new HashMap(3);

    public PageQuestionInfo(int pageNumber, int questionNumber, String type) {
      this(pageNumber, questionNumber, type, 1, 1);
    }

    public PageQuestionInfo(int pageNumber, int questionNumber, String type,
                            int minAnswer, int maxAnswer)
    {
      this.pageNumber = pageNumber;
      this.questionNumber = questionNumber;
      this.type = type;
      this.minAnswer = minAnswer;
      this.maxAnswer = maxAnswer;
    }

    public int getPageNumber() { return pageNumber; }
    public int getQuestionNumber() { return questionNumber; }
    public String getType() { return type; }
    public int getMinAnswer() { return minAnswer; }
    public int getMaxAnswer() { return maxAnswer; }

    public void addScoreNameIDAssoc(String scoreName, int id) {
       scoreNameIDMAp.put(scoreName, new Integer(id));
    }

    public Integer getIDForScoreName(String scoreName) {
       return (Integer) scoreNameIDMAp.get(scoreName);
    }

    public void addScoreName(String scoreName) {
      scoreNames.add(scoreName);
    }

    public List getScoreNames() { return scoreNames; }
  }


    public static Map getPageQuestionsMap() {
      synchronized(ASIForm.class) {
        if (pageQuestionsMap == null) {
          pageQuestionsMap = new LinkedHashMap();

          List list = null;
          PageQuestionInfo pqi = null;
          list = new LinkedList();
          pageQuestionsMap.put( new Integer(2), list);
          list.add( pqi = new PageQuestionInfo(2,18,"regular") );
          pqi.addScoreName("face flushing");
          pqi.addScoreNameIDAssoc("face flushing",0);
          list.add( pqi = new PageQuestionInfo(2,20,"regular") );
          pqi.addScoreName("nightmares");
          pqi.addScoreNameIDAssoc("nightmares",0);
          list.add( pqi = new PageQuestionInfo(2,13,"regular") );
          pqi.addScoreName("dyspnea");
          pqi.addScoreNameIDAssoc("dyspnea",0);
          list.add( pqi = new PageQuestionInfo(2,9,"regular") );
          pqi.addScoreName("restlessness");
          pqi.addScoreNameIDAssoc("restlessness",0);
          list.add( pqi = new PageQuestionInfo(2,19,"regular") );
          pqi.addScoreName("insomnia");
          pqi.addScoreNameIDAssoc("insomnia",0);
          list.add( pqi = new PageQuestionInfo(2,3,"regular") );
          pqi.addScoreName("panic");
          pqi.addScoreNameIDAssoc("panic",0);
          list.add( pqi = new PageQuestionInfo(2,17,"regular") );
          pqi.addScoreName("sweating");
          pqi.addScoreNameIDAssoc("sweating",0);
          list.add( pqi = new PageQuestionInfo(2,14,"regular") );
          pqi.addScoreName("paresthesias");
          pqi.addScoreNameIDAssoc("paresthesias",0);
          list.add( pqi = new PageQuestionInfo(2,1,"regular") );
          pqi.addScoreName("anxiousness");
          pqi.addScoreNameIDAssoc("anxiousness",0);
          list.add( pqi = new PageQuestionInfo(2,6,"regular") );
          pqi.addScoreName("tremors");
          pqi.addScoreNameIDAssoc("tremors",0);
          list.add( pqi = new PageQuestionInfo(2,5,"regular") );
          pqi.addScoreName("apprehension");
          pqi.addScoreNameIDAssoc("apprehension",0);
          list.add( pqi = new PageQuestionInfo(2,16,"regular") );
          pqi.addScoreName("urinary frequency");
          pqi.addScoreNameIDAssoc("urinary frequency",0);
          list.add( pqi = new PageQuestionInfo(2,15,"regular") );
          pqi.addScoreName("nausea and vomiting");
          pqi.addScoreNameIDAssoc("nausea and vomiting",0);
          list.add( pqi = new PageQuestionInfo(2,11,"regular") );
          pqi.addScoreName("dizziness");
          pqi.addScoreNameIDAssoc("dizziness",0);
          list.add( pqi = new PageQuestionInfo(2,4,"regular") );
          pqi.addScoreName("mental disintegration");
          pqi.addScoreNameIDAssoc("mental disintegration",0);
          list.add( pqi = new PageQuestionInfo(2,12,"regular") );
          pqi.addScoreName("faintness");
          pqi.addScoreNameIDAssoc("faintness",0);
          list.add( pqi = new PageQuestionInfo(2,7,"regular") );
          pqi.addScoreName("body aches and pains");
          pqi.addScoreNameIDAssoc("body aches and pains",0);
          list.add( pqi = new PageQuestionInfo(2,2,"regular") );
          pqi.addScoreName("fear");
          pqi.addScoreNameIDAssoc("fear",0);
          list.add( pqi = new PageQuestionInfo(2,21,"regular") );
          pqi.addScoreName("ASI index");
          pqi.addScoreNameIDAssoc("ASI index",0);
          list.add( pqi = new PageQuestionInfo(2,10,"regular") );
          pqi.addScoreName("palpitation");
          pqi.addScoreNameIDAssoc("palpitation",0);
          list.add( pqi = new PageQuestionInfo(2,8,"regular") );
          pqi.addScoreName("easy fatiguability weakness");
          pqi.addScoreNameIDAssoc("easy fatiguability weakness",0);
        }
      }
      return pageQuestionsMap;
    }

    private String q18_notes = "";
    private String q20_notes = "";
    private String q13_notes = "";
    private String q9_notes = "";
    private String q19_notes = "";
    private String q3_notes = "";
    private String q17_notes = "";
    private String q14_notes = "";
    private String q1_notes = "";
    private String q6_notes = "";
    private String q5_notes = "";
    private String q16_notes = "";
    private String q15_notes = "";
    private String q11_notes = "";
    private String q4_notes = "";
    private String q12_notes = "";
    private String q7_notes = "";
    private String q2_notes = "";
    private String q21_notes = "";
    private String q10_notes = "";
    private String q8_notes = "";

    public String getQ18_notes() {  return this.q18_notes; }
    public void setQ18_notes(String newValue) {  this.q18_notes = newValue; }
    public String getQ20_notes() {  return this.q20_notes; }
    public void setQ20_notes(String newValue) {  this.q20_notes = newValue; }
    public String getQ13_notes() {  return this.q13_notes; }
    public void setQ13_notes(String newValue) {  this.q13_notes = newValue; }
    public String getQ9_notes() {  return this.q9_notes; }
    public void setQ9_notes(String newValue) {  this.q9_notes = newValue; }
    public String getQ19_notes() {  return this.q19_notes; }
    public void setQ19_notes(String newValue) {  this.q19_notes = newValue; }
    public String getQ3_notes() {  return this.q3_notes; }
    public void setQ3_notes(String newValue) {  this.q3_notes = newValue; }
    public String getQ17_notes() {  return this.q17_notes; }
    public void setQ17_notes(String newValue) {  this.q17_notes = newValue; }
    public String getQ14_notes() {  return this.q14_notes; }
    public void setQ14_notes(String newValue) {  this.q14_notes = newValue; }
    public String getQ1_notes() {  return this.q1_notes; }
    public void setQ1_notes(String newValue) {  this.q1_notes = newValue; }
    public String getQ6_notes() {  return this.q6_notes; }
    public void setQ6_notes(String newValue) {  this.q6_notes = newValue; }
    public String getQ5_notes() {  return this.q5_notes; }
    public void setQ5_notes(String newValue) {  this.q5_notes = newValue; }
    public String getQ16_notes() {  return this.q16_notes; }
    public void setQ16_notes(String newValue) {  this.q16_notes = newValue; }
    public String getQ15_notes() {  return this.q15_notes; }
    public void setQ15_notes(String newValue) {  this.q15_notes = newValue; }
    public String getQ11_notes() {  return this.q11_notes; }
    public void setQ11_notes(String newValue) {  this.q11_notes = newValue; }
    public String getQ4_notes() {  return this.q4_notes; }
    public void setQ4_notes(String newValue) {  this.q4_notes = newValue; }
    public String getQ12_notes() {  return this.q12_notes; }
    public void setQ12_notes(String newValue) {  this.q12_notes = newValue; }
    public String getQ7_notes() {  return this.q7_notes; }
    public void setQ7_notes(String newValue) {  this.q7_notes = newValue; }
    public String getQ2_notes() {  return this.q2_notes; }
    public void setQ2_notes(String newValue) {  this.q2_notes = newValue; }
    public String getQ21_notes() {  return this.q21_notes; }
    public void setQ21_notes(String newValue) {  this.q21_notes = newValue; }
    public String getQ10_notes() {  return this.q10_notes; }
    public void setQ10_notes(String newValue) {  this.q10_notes = newValue; }
    public String getQ8_notes() {  return this.q8_notes; }
    public void setQ8_notes(String newValue) {  this.q8_notes = newValue; }
    
    public void reset(ActionMapping mapping, HttpServletRequest request) {
    }
}
