package clinical.web.game.forms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.struts.util.LabelValueBean;

/**
 * Helper class for dynamic drop downs in the CALM generated online assessments.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DynamicDropDownSelector.java,v 1.2 2005/11/02 00:37:14 bozyurt
 *          Exp $
 */
public class DynamicDropDownSelector {
	protected List<LabelValueBean> possibleSelections;
	protected int selectedItemIdx;

	public DynamicDropDownSelector(List<String> values) {
		possibleSelections = new ArrayList<LabelValueBean>(values.size());
		boolean first = true;
		int idx = 0;
		for (String value : values) {
			LabelValueBean lvb = new LabelValueBean(value, String.valueOf(idx));
			possibleSelections.add(lvb);
			if (first) {
				selectedItemIdx = idx;
				first = false;
			}
			++idx;
		}
	}

	public Collection<LabelValueBean> getPossibleSelections() {
		return this.possibleSelections;
	}

	public String getPossibleSelection(int idx) {
		LabelValueBean lvb = possibleSelections.get(idx);
		return lvb.getLabel();
	}

	public void setSelectedItemIdx(int newSelectedItemIdx) {
		this.selectedItemIdx = newSelectedItemIdx;
	}

	public int getSelectedItemIdx() {
		return this.selectedItemIdx;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer(56);
		buf.append("DynamicDropDownSelector::[");
		buf.append("selectedItemIdx=").append(selectedItemIdx);
		buf.append(']');
		return buf.toString();
	}

}
