package clinical.web.helpers;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.server.vo.Assessment;
import clinical.server.vo.Assessmentscore;
import clinical.server.vo.Assessmentscorecode;
import clinical.web.IAssessmentService;
import clinical.web.common.UserInfo;
import clinical.web.common.vo.AsScoreInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.forms.AsQueryBuilderForm;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentSelectionInfoHelper.java,v 1.2 2006/01/23 20:05:59
 *          bozyurt Exp $
 */
public class AssessmentSelectionInfoHelper {
	protected IAssessmentService asService;
	protected UserInfo ui;
	protected Map<BigDecimal, AssessmentSelectionInfo> asiMap;
	protected Map<String, AsScoreInfo> scoreMap;
	protected Map<String, List<Assessmentscorecode>> scoreCodeMap;
	private Log log = LogFactory.getLog(AssessmentSelectionInfoHelper.class);

	public AssessmentSelectionInfoHelper(IAssessmentService asService,
			UserInfo ui, List<Assessment> assessments,
			Map<String, List<Assessmentscorecode>> scoreCodeMap) {
		this.asService = asService;
		this.ui = ui;
		this.scoreCodeMap = scoreCodeMap;

		asiMap = new LinkedHashMap<BigDecimal, AssessmentSelectionInfo>();
		for (Assessment as : assessments) {
			AssessmentSelectionInfo asi = new AssessmentSelectionInfo();
			asi.setAssessmentID(as.getAssessmentid());
			asi.setDescription(as.getDescription());
			asi.setName(as.getName());
			asiMap.put(asi.getAssessmentID(), asi);
		}
		scoreMap = new LinkedHashMap<String, AsScoreInfo>();
	}

	public AssessmentSelectionInfoHelper(IAssessmentService asService,
			UserInfo ui, AsQueryBuilderForm queryForm,
			Map<String, List<Assessmentscorecode>> scoreCodeMap) {
		this.asService = asService;
		this.ui = ui;
		this.scoreCodeMap = scoreCodeMap;
		asiMap = new LinkedHashMap<BigDecimal, AssessmentSelectionInfo>();
		for (AssessmentSelectionInfo asi : queryForm.getAssessments()) {
			asiMap.put(asi.getAssessmentID(), asi);
		}
		log.info("asiMap size=" + asiMap.size());
		scoreMap = new LinkedHashMap<String, AsScoreInfo>(71);

	}

	public void loadScores(AssessmentSelectionInfo asi) throws Exception {
		Assessment a = new Assessment();
		a.setAssessmentid(asi.getAssessmentID());
		List<?> scoreList = asService.getScoresForAssessment(ui, a);
		log.debug("got the list of scores size= " + scoreList.size());

		// sort by score order
		Collections.sort(scoreList, new Comparator<Object>() {
			public int compare(final Object o1, final Object o2) {
				final Assessmentscore s1 = (Assessmentscore) o1;
				final Assessmentscore s2 = (Assessmentscore) o2;
				return s1.getScoresequence().intValue()
						- s2.getScoresequence().intValue();
			}
		});
		for (Iterator<?> it2 = scoreList.iterator(); it2.hasNext();) {
			Assessmentscore score = (Assessmentscore) it2.next();
			AsScoreInfo si = new AsScoreInfo(asi.getAssessmentID());
			si.setName(score.getScorename());
			si.setType(score.getScoretype());
			si.setSequence(score.getScoresequence().intValue());
			asi.addScore(si);
			scoreMap.put(prepareScoreKey(asi.getAssessmentID(), si.getName()),
					si);
		}
	}

	protected String prepareScoreKey(BigDecimal asID, String scoreName) {
		StringBuffer sb = new StringBuffer();
		sb.append(asID).append('_').append(scoreName);
		return sb.toString();
	}

	public AsScoreInfo findAsScoreInfo(BigDecimal asID, String scoreName)
			throws Exception {
		AsScoreInfo si = scoreMap.get(prepareScoreKey(asID, scoreName));
		if (si == null) {
			// first check if the assessment exists
			AssessmentSelectionInfo asi = asiMap.get(asID);
			if (asi != null) {
				try {
					log.info("findAsScoreInfo: loading scores.");
					loadScores(asi);
					return scoreMap.get(prepareScoreKey(asID, scoreName));
				} catch (Exception x) {
					log.error("Error in loading scores", x);
					throw x;
				}
			}
		}
		return si;
	}

	public List<AsScoreInfo> getAllScoreInfosForAssessment(BigDecimal asID) throws Exception {
		AssessmentSelectionInfo asi = asiMap.get(asID);
		if (asi == null)
			return null;
		return asi.getScores();
	}

	public AssessmentSelectionInfo findAssessmentSelectionInfo(BigDecimal asID,
			boolean loadScores) throws Exception {
		AssessmentSelectionInfo asi = asiMap.get(asID);
		if (asi != null && loadScores) {
			if (asi.getScores() == null || asi.getScores().isEmpty()) {
				loadScores(asi);
			}
		}
		return asi;
	}

	public List<String> getScoreCodesForScore(BigDecimal asID, String scoreName) {
		String key = asID.toString() + "_" + scoreName;
		List<Assessmentscorecode> scList = scoreCodeMap.get(key);
		List<String> scoreCodes = new ArrayList<String>(scList.size());
		for (Assessmentscorecode asc : scList) {
			scoreCodes.add(asc.getScorecode());
		}
		return scoreCodes;
	}

}
