package clinical.web.helpers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import clinical.utils.FileUtils;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.services.BatchQueryResult;
import clinical.web.services.AssessmentServiceHelper.SiteAsiInfo;
import clinical.web.vo.SubjectAsScoreValueSummary;

/**
 * @author I. Burak Ozyurt
 * @version $Id: BatchQueryHelper.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class BatchQueryHelper {

	public static void prepareCSVFile(File file, BatchQueryResult bqr)
			throws Exception {
		BufferedWriter out = null;

		StringBuilder buf = new StringBuilder(256);
		buf.append("SubjectID,");
		buf.append("Site ID,");
		buf.append("Experiment ID,");
		buf.append("Visit ID,");
		buf.append("Segment ID,");
		buf.append("Assessment Name,");
		buf.append("Score Name,");
		buf.append("Score Value");
		String header = buf.toString();

		Map<String, String> map = new HashMap<String, String>(37);
		String theSite = null;
		Set<String> seenSites = new HashSet<String>(17);
		for (Map.Entry<String, SiteAsiInfo> entry : bqr.getSaiMap().entrySet()) {
			String siteID = entry.getKey();
			if (!seenSites.contains(siteID.toUpperCase())) {
				theSite = siteID.toUpperCase();
				seenSites.add(theSite);
			}
			SiteAsiInfo sai = entry.getValue();

			for (AssessmentSelectionInfo asi : sai.getAsiList()) {
				StringBuffer keyBuf = new StringBuffer(asi.getAssessmentID()
						.toString());
				keyBuf.append('_').append(siteID.toUpperCase());
				map.put(keyBuf.toString(), asi.getName());
			}
		}
		if (seenSites.size() > 1) {
			theSite = null;
		}

		try {
			out = new BufferedWriter(new FileWriter(file));

			out.write(header);
			out.newLine();

			String[] row = new String[8];
			for (SubjectAsScoreValueSummary sasvs : bqr.getCombinedList()) {
				row[0] = sasvs.getSubjectID();
				String siteID = sasvs.getSiteID();

				if (siteID == null) {
					row[1] = sasvs.getSubjectID().substring(0, 4);
				} else {
					row[1] = siteID;
				}

				String asName = null;
				StringBuilder keyBuf = new StringBuilder();
				keyBuf.append(sasvs.getAssessmentID()).append('_');
				keyBuf.append(siteID.toUpperCase());
				asName = map.get(keyBuf.toString());
				if (asName == null) {
					// hack for BDR
					// in BDR data from multiple sites are pooled , they have
					// different site ids but same assessment ids
					if (theSite != null) {
						keyBuf = new StringBuilder();
						keyBuf.append(sasvs.getAssessmentID()).append('_')
								.append(theSite);
						asName = map.get(keyBuf.toString());
					}
				}

				row[2] = String.valueOf(sasvs.getExperimentID());
				row[3] = String.valueOf(sasvs.getVisitID());
				row[4] = String.valueOf(sasvs.getSegmentID());
				row[5] = asName;
				row[6] = sasvs.getScoreName();
				// TODO multiple values per score
				row[7] = sasvs.getValue() != null ? sasvs.getValue().toString()
						: ".";
				buf = new StringBuilder(200);
				for (int i = 0; i < row.length; i++) {
					buf.append(row[i]).append(',');
				}
				out.write(buf.substring(0, buf.length() - 1));
				out.newLine();
			}

		} finally {
			FileUtils.close(out);
		}
	}

	public static void prepareCSVFile(File file,
			List<AssessmentSelectionInfo> asiList, BatchQueryResult bqr)
			throws Exception {
		BufferedWriter out = null;

		StringBuffer buf = new StringBuffer(256);
		buf.append("SubjectID,");
		buf.append("Site ID,");
		buf.append("Experiment ID,");
		buf.append("Visit ID,");
		buf.append("Segment ID,");
		buf.append("Assessment Name,");
		buf.append("Score Name,");
		buf.append("Score Value");
		String header = buf.toString();

		Map<String, String> map = new HashMap<String, String>(37);
		for (SiteAsiInfo sai : bqr.getSaiMap().values()) {
			for (AssessmentSelectionInfo asi : sai.getAsiList()) {
				StringBuilder sb = new StringBuilder(sai.getSiteID());
				sb.append('_').append(asi.getAssessmentID().toString());
				map.put(sb.toString(), asi.getName());
			}
		}

		try {
			out = new BufferedWriter(new FileWriter(file));

			out.write(header);
			out.newLine();

			String[] row = new String[8];
			for (SubjectAsScoreValueSummary sasvs : bqr.getCombinedList()) {
				row[0] = sasvs.getSubjectID();
				if (sasvs.getSiteID() == null) {
					row[1] = sasvs.getSubjectID().substring(0, 4);
				} else {
					row[1] = sasvs.getSiteID();
				}

				row[2] = String.valueOf(sasvs.getExperimentID());
				row[3] = String.valueOf(sasvs.getVisitID());
				row[4] = String.valueOf(sasvs.getSegmentID());
				StringBuilder sb = new StringBuilder();
				// TODO assumption: the first 4 digits of the BIRN ID indicates
				// the acquisition AND retrieval site ID
				// if siteID is not explicitly specified.
				if (sasvs.getSiteID() != null) {
					sb.append(sasvs.getSiteID());
				} else {
					sb.append(sasvs.getSubjectID().substring(0, 4));
				}
				sb.append('_').append(sasvs.getAssessmentID());
				String key = sb.toString();
				row[5] = map.get(key);
				row[6] = sasvs.getScoreName();
				if (sasvs.isMultiValued()) {
					for (Object value : sasvs.getValues()) {
						row[7] = value != null ? value.toString() : ".";
						writeRow(out, row);
					}
				} else {
					row[7] = sasvs.getValue() != null ? sasvs.getValue()
							.toString() : ".";
					writeRow(out, row);
				}

			}

		} finally {
			FileUtils.close(out);
		}
	}

	protected static void writeRow(BufferedWriter out, String[] row)
			throws IOException {
		StringBuilder sb;
		sb = new StringBuilder(200);
		for (int i = 0; i < row.length; i++) {
			sb.append(row[i]).append(',');
		}
		out.write(sb.substring(0, sb.length() - 1));
		out.newLine();
	}
}
