package clinical.web.helpers;

import java.util.HashMap;
import java.util.Map;

import javax.mail.MessagingException;

import clinical.utils.EmailSender;

/**
 * @author I. Burak Ozyurt
 * @version $Id: EmailHelper.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class EmailHelper {
	protected String emailHost;
	protected String emailUser;
	protected String emailPwd;
	protected String emailFrom;
	protected String toUser;
	
	protected static final String JOB_STATUS_NOTIFICATION_TEMPLATE =
	"From HID Web Application User Notification System:\n\n" +
	"Hi ${client},\n" +
	"Your ${job_type} with id ${jobid} is finished ${status}\n";
	
	public EmailHelper(String emailHost, String emailUser, String emailPwd,
			String emailFrom) {
		super();
		this.emailHost = emailHost;
		this.emailUser = emailUser;
		this.emailPwd = emailPwd;
		this.emailFrom = emailFrom;
	}
	
	
	public void sendEmail(Map<String, String> paramMap) throws MessagingException {
		EmailSender mailer = new EmailSender(emailUser, emailHost, emailFrom, emailPwd, false);
		
		String subject = paramMap.get("subject");
		String toEmail = paramMap.get("client");
		String message = JOB_STATUS_NOTIFICATION_TEMPLATE;
		for (Map.Entry<String,String> entry : paramMap.entrySet()) {
			String macro = entry.getKey();
			macro = "\\$\\{" + macro + "\\}";	
			String value = entry.getValue();
			message = message.replaceAll(macro, value);
		}
		
		System.out.println(message);
		mailer.sendMessage(toEmail, subject, message);
	}
	
	
	public static void main(String[] args) throws MessagingException {
		EmailHelper helper = new EmailHelper("popmail.ucsd.edu","", "", "");
		
		Map<String, String> paramMap = new HashMap<String, String>();
		paramMap.put("subject", "your image download job is ready!");
		paramMap.put("client", "iozyurt@ucsd.edu");
		paramMap.put("job_type", "project download job");
		paramMap.put("jobid", "123456");
		paramMap.put("status", ".\nYou can download it at your convenience by login to the HID web application");
		
		helper.sendEmail(paramMap);
	}


	public String getToUser() {
		return toUser;
	}


	public void setToUser(String toUser) {
		this.toUser = toUser;
	}
}
