package clinical.web.helpers;

import org.apache.commons.math.stat.regression.SimpleRegression;

import clinical.utils.GenUtils;

/*******************************************************************************
 * @author I. Burak Ozyurt
 * @version $Id: RegressionInfo.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class RegressionInfo {
    /** Pearson's product moment correlation coefficient*/
    double r;
    /** coefficient of determination */
    double rsquare;
    double meanSquareError;
    double intercept;
    double slope;
    double significance;
    double interceptStdErr;
    double slopeStdErr;
    /** half-width of 95% confidence interval for the slope estimate.*/
    Double slopeConfidenceInterval;
    /** number of observations */
    long n;
    String title;
    
	public RegressionInfo(SimpleRegression reg, String title) {
		this.title = title;
		r = reg.getR();
		rsquare = reg.getRSquare();
		meanSquareError = reg.getMeanSquareError();
		intercept = reg.getIntercept();
		slope = reg.getSlope();
		try {
			significance = reg.getSignificance();
		} catch (Throwable t) {
			significance = 0;
		}
		interceptStdErr = reg.getInterceptStdErr();
		slopeStdErr = reg.getSlopeStdErr();
		try {
			slopeConfidenceInterval = new Double( reg.getSlopeConfidenceInterval() );
		} catch (Throwable t) {
			slopeConfidenceInterval = null;
		}
		n = reg.getN();
		
	}

	public double getIntercept() {
		return intercept;
	}
	
	public String getInterceptValue() {
		return GenUtils.formatNumber(intercept, 3);
	}

	public void setIntercept(double intercept) {
		this.intercept = intercept;
	}

	public double getInterceptStdErr() {
		return interceptStdErr;
	}

	public void setInterceptStdErr(double interceptStdErr) {
		this.interceptStdErr = interceptStdErr;
	}

	public double getMeanSquareError() {
		return meanSquareError;
	}

	public String getMeanSquareErrorValue() {
		return GenUtils.formatNumber(meanSquareError, 1);
	}
	
	public void setMeanSquareError(double meanSquareError) {
		this.meanSquareError = meanSquareError;
	}
	

	public long getN() {
		return n;
	}

	public void setN(long n) {
		this.n = n;
	}

	public double getR() {
		return r;
	}
	
	public String getRvalue() {
		return GenUtils.formatNumber(r, 3);
	}

	public void setR(double r) {
		this.r = r;
	}

	public double getRsquare() {
		return rsquare;
	}
	
	public String getRsquareValue() {
		return GenUtils.formatNumber(rsquare, 3);
	}

	public void setRsquare(double square) {
		rsquare = square;
	}

	public double getSignificance() {
		return significance;
	}

	public void setSignificance(double significance) {
		this.significance = significance;
	}

	public double getSlope() {
		return slope;
	}
	
	public String getSlopeValue() {
		return GenUtils.formatNumber(slope,3);
	}

	public void setSlope(double slope) {
		this.slope = slope;
	}

	public Double getSlopeConfidenceInterval() {
		return slopeConfidenceInterval;
	}
	
	public String getSlopeConfidenceIntervalValue() {
		double value = slopeConfidenceInterval != null ? slopeConfidenceInterval.doubleValue() : Double.NaN;
		return GenUtils.formatNumber(value,3);
	}

	
	public double getSlopeStdErr() {
		return slopeStdErr;
	}

	public void setSlopeStdErr(double slopeStdErr) {
		this.slopeStdErr = slopeStdErr;
	}

	public String getTitle() {
		return title;
	}

}
