package clinical.web.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

import org.apache.struts.util.LabelValueBean;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ScoresSelector.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class ScoresSelector {
	protected Collection<LabelValueBean> scores;
	protected String[] selectedScores = new String[0];

	public ScoresSelector(Map<String, String> scoreKeyNameMap) {
		scores = new ArrayList<LabelValueBean>(scoreKeyNameMap.size());
		for (Map.Entry<String, String> entry : scoreKeyNameMap.entrySet()) {
			String scoreKey = (String) entry.getKey();
			String scoreName = (String) entry.getValue();
			LabelValueBean lvb = new LabelValueBean(scoreName, scoreKey);
			scores.add(lvb);
		}
	}

	public void setScores(Collection<LabelValueBean> newScores) {
		this.scores = newScores;
	}

	public void setSelectedScores(String[] newSelectedScores) {
		this.selectedScores = newSelectedScores;
	}

	public Collection<LabelValueBean> getScores() {
		return this.scores;
	}

	public String[] getSelectedScores() {
		return this.selectedScores;
	}

	public int indexOf(String selectedScoreName) {
		for (int i = 0; i < selectedScores.length; i++) {
			if (selectedScores[i].equals(selectedScoreName)) {
				return i;
			}
		}
		return -1;
	}

}
