package clinical.web.helpers;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.struts.util.LabelValueBean;

import clinical.server.vo.Protocol;
import clinical.utils.DateTimeUtils;
import clinical.utils.GenUtils;
import clinical.web.forms.SubjectVisitManagementForm;
import clinical.web.vo.StudySegment;
import clinical.web.vo.VisitSegment;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SegmentFormInfo.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class SegmentFormInfo {
	protected VisitSegment visitSegment;
	protected StudySegment studySegment;
	protected List<LabelValueBean> protocolLVList;
	protected String date = "";
	protected String time = "";
	protected String description = "";
	protected String protocolValue;
	protected String name;
	protected SubjectVisitManagementForm svmForm;
	protected SimpleDateFormat df;
	protected boolean dirty = false;
	protected static boolean VERBOSE = false;

	public SegmentFormInfo(VisitSegment vs, String[] protocolNames,
			int[] protocolVersions, SubjectVisitManagementForm svmForm) {
		this.visitSegment = vs;
		init(vs, protocolNames, protocolVersions, svmForm);
		if ( VERBOSE) {
			logCreation("created SegmentFormInfo with visit segment(s) "
					+ toString());
		}
	}

	public SegmentFormInfo(StudySegment ss, String[] protocolNames,
			int[] protocolVersions, SubjectVisitManagementForm svmForm) {
		this.studySegment = ss;
		init(ss, protocolNames, protocolVersions, svmForm);
		logCreation("created SegmentFormInfo with study segment(s) "
				+ toString());
	}

	private void logCreation(String msg) {
		System.out.println("\n\n" + msg);
		try {
			throw new Exception();
		} catch (Exception x) {
			StackTraceElement[] stElems = GenUtils.prepareStackTrace(x,
					"clinical");
			for (int i = 0; i < stElems.length; i++) {
				System.out.println(stElems[i].toString());
			}
		}
		System.out.println("--- end of SegmentFormInfo creation");
	}

	private void init(VisitSegment vs, String[] protocolNames,
			int[] protocolVersions, SubjectVisitManagementForm svmForm) {
		this.svmForm = svmForm;
		protocolLVList = new ArrayList<LabelValueBean>(protocolNames.length);
		for (int i = 0; i < protocolNames.length; i++) {
			String label = protocolNames[i] + " Version " + protocolVersions[i];
			String value = protocolNames[i] + " " + protocolVersions[i];
			protocolLVList.add(new LabelValueBean(label, value));
		}
		if (vs.getTimeStamp() != null) {
			// get time part from the timestamp
			this.time = DateTimeUtils.extractTimePart(vs.getTimeStamp());
			this.date = DateTimeUtils.formatTimestampToDate(vs.getTimeStamp());
		}
		description = vs.getDescription();
		name = vs.getName();
	}

	public void setDirty(boolean newDirty) {
		this.dirty = newDirty;
	}

	public boolean isDirty() {
		return this.dirty;
	}

	private void init(StudySegment ss, String[] protocolNames,
			int[] protocolVersions, SubjectVisitManagementForm svmForm) {
		this.svmForm = svmForm;
		protocolLVList = new ArrayList<LabelValueBean>(protocolNames.length);
		for (int i = 0; i < protocolNames.length; i++) {
			String label = protocolNames[i] + " Version " + protocolVersions[i];
			String value = protocolNames[i] + " " + protocolVersions[i];
			protocolLVList.add(new LabelValueBean(label, value));
		}
		if (ss.getTimeStamp() != null) {
			// get time part from the timestamp
			this.time = DateTimeUtils.extractTimePart(ss.getTimeStamp());
			this.date = DateTimeUtils.formatTimestampToDate(ss.getTimeStamp());
		}
		description = ss.getDescription();
		name = ss.getName();
	}

	public StudySegment getStudySegment() {
		return this.studySegment;
	}

	public VisitSegment getVisitSegment() {
		return visitSegment;
	}

	public Collection<LabelValueBean> getProtocols() {
		return protocolLVList;
	}

	public String getDate() {
		return date;
	}

	public void setDate(String newDate) {
		this.date = newDate;
		if (time != null && time.trim().length() > 0 && date != null
				&& date.trim().length() > 0) {
			if (visitSegment != null)
				visitSegment.setTimeStamp(DateTimeUtils.prepareTimeStamp(
						DateTimeUtils.toTimeStamp(date), time));
			if (studySegment != null)
				studySegment.setTimeStamp(DateTimeUtils.prepareTimeStamp(
						DateTimeUtils.toTimeStamp(date), time));
		}
		setDirty(true);
	}

	public String getTime() {
		return time;
	}

	public void setTime(String newTime) {
		this.time = newTime;
		if (time != null && time.trim().length() > 0 && date != null
				&& date.trim().length() > 0) {
			if (visitSegment != null)
				visitSegment.setTimeStamp(DateTimeUtils.prepareTimeStamp(
						DateTimeUtils.toTimeStamp(date), time));
			if (studySegment != null)
				studySegment.setTimeStamp(DateTimeUtils.prepareTimeStamp(
						DateTimeUtils.toTimeStamp(date), time));
		}
		setDirty(true);
	}

	public void setProtocolValue(String newProtocolValue) {
		this.protocolValue = newProtocolValue;
		int idx = protocolValue.lastIndexOf(' ');
		String protocolName = protocolValue.substring(0, idx);
		int protocolVersion = Integer
				.parseInt(protocolValue.substring(idx + 1));
		for (Protocol pr : svmForm.getProtocols()) {
			if (pr.getName().equals(protocolName)
					&& pr.getProtocolversion().intValue() == protocolVersion) {
				if (visitSegment != null) {
					visitSegment.setProtocolVersion(protocolVersion);
					visitSegment.setProtocolID(pr.getProtocolid());
				}
				if (studySegment != null) {
					studySegment.setProtocolVersion(protocolVersion);
					studySegment.setProtocolID(pr.getProtocolid());
				}
				break;
			}
		}
		setDirty(true);
	}

	public String getProtocolValue() {
		return this.protocolValue;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String newDescription) {
		this.description = newDescription;
		System.out.println("\n***** setting description=" + description);
		System.out.println("SegmentFormInfo" + toString());

		if (visitSegment != null)
			visitSegment.setDescription(description);
		if (studySegment != null) {
			studySegment.setDescription(description);
		}
		setDirty(true);
	}

	public void setName(String newName) {
		this.name = newName;
		if (visitSegment != null)
			visitSegment.setName(name);
		if (studySegment != null)
			studySegment.setName(name);
		setDirty(true);
	}

	public String getName() {
		return this.name;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer(176);
		buf.append("SegmentFormInfo::[");
		buf.append("date=").append(date);
		buf.append(", time=").append(time);
		buf.append(", description=").append(description);
		buf.append(", protocolValue=").append(protocolValue);
		buf.append(", name=").append(name);
		buf.append(", visitSegment=" + visitSegment);
		buf.append(", studySegment=" + studySegment);

		buf.append(']');
		return buf.toString();
	}

}
