package clinical.web.scheduler;

import java.io.File;

import clinical.web.common.UserInfo;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: IJob.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public interface IJob {
	/**
	 * returns the unique id of the job
	 * @return
	 */
	public String getID();

	/**
	 *
	 * @return
	 */
	public String getUser();

	/**
	 * returns the job type
	 * @return
	 */
	public String getType();

	/**
	 *
	 * @return
	 */
	public String getDescription();

	/**
	 * main work is done here.
	 *
	 * @throws JobException
	 */
	public void execute() throws JobException;


	/**
	 *
	 * @param file
	 * @throws JobException
	 */
	public void saveResults(File file) throws JobException;

	/**
	 * the full paths for the files where the results will be saved
	 * @return
	 */
	public String[] getResultsFiles();

	/**
	 * in order the job to be cancelable this method needs to set a flag
	 * when called and the logic in <code>execute()</code> should
	 * check for this flag periodically.
	 *
	 */
	public void cancel();

	public String getDbID();

	public UserInfo getUserInfo();
}
