package clinical.web.services;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import clinical.server.vo.Deriveddata;
import clinical.server.vo.Executedtransform;
import clinical.server.vo.Transformeddata;
import clinical.server.vo.Transforminputdata;

/**
 * @author I. Burak Ozyurt
 * @version $Id: AnalysisInstanceDataResult.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class AnalysisInstanceDataResult {
	protected String subjectID;
	protected Integer expID;
	protected Integer visitID;
	protected Integer segmentID;
	protected List<ExTransformData> etdList = new ArrayList<ExTransformData>(3);
	protected Map<BigDecimal, ExTransformData> etdMap = new HashMap<BigDecimal, ExTransformData>(
			7);
	protected Set<BigDecimal> analysisIDSet = new HashSet<BigDecimal>(7);

	public AnalysisInstanceDataResult(String subjectID, Integer expID,
			Integer visitID, Integer segmentID) {
		super();
		this.subjectID = subjectID;
		this.expID = expID;
		this.visitID = visitID;
		this.segmentID = segmentID;
	}

	public void addExecutedTransformsAndOutputDerivedData(
			Map<Executedtransform, Map<Transformeddata, Deriveddata>> outMap) {

		for (Map.Entry<Executedtransform, Map<Transformeddata, Deriveddata>> entry : outMap
				.entrySet()) {
			Executedtransform et = entry.getKey();
			analysisIDSet.add(et.getAnalysisid());
			Map<Transformeddata, Deriveddata> tdMap = entry.getValue();
			ExTransformData etd = etdMap.get(et.getUniqueid());
			if ( etd == null) {
				etd = new ExTransformData(et);
				etdMap.put(et.getUniqueid(), etd);
				etdList.add(etd);
			}
			etd.outDataMap.putAll(tdMap);			
		}
	}
	
	public void addExecutedTransformsAndInputDerivedData(
			Map<Executedtransform, Map<Transforminputdata, Deriveddata>> inMap) {

		for (Map.Entry<Executedtransform, Map<Transforminputdata, Deriveddata>> entry : inMap
				.entrySet()) {
			Executedtransform et = entry.getKey();
			analysisIDSet.add(et.getAnalysisid());
			Map<Transforminputdata, Deriveddata> tdMap = entry.getValue();
			ExTransformData etd = etdMap.get(et.getUniqueid());
			if ( etd == null) {
				etd = new ExTransformData(et);
				etdMap.put(et.getUniqueid(), etd);
				etdList.add(etd);
			}
			etd.inDataMap.putAll(tdMap);			
		}
	}
	
	public String getSubjectID() {
		return subjectID;
	}

	public Integer getExpID() {
		return expID;
	}

	public Integer getVisitID() {
		return visitID;
	}

	public Integer getSegmentID() {
		return segmentID;
	}

	public List<ExTransformData> getEtdList() {
		return etdList;
	}
	
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("AnalysisInstanceDataResult::[");
	    for (ExTransformData etd : etdList) {
			buf.append("\n").append(etd);
		}
		buf.append(']');
		return buf.toString();
	}

	public static class ExTransformData {
		Executedtransform et;
		Map<Transforminputdata, Deriveddata> inDataMap = new HashMap<Transforminputdata, Deriveddata>(7);
		Map<Transformeddata, Deriveddata> outDataMap = new HashMap<Transformeddata, Deriveddata>(7);

		public ExTransformData(Executedtransform et) {
			this.et = et;
		}

		public Executedtransform getEt() {
			return et;
		}

		public Map<Transforminputdata, Deriveddata> getInDataMap() {
			return inDataMap;
		}

		public Map<Transformeddata, Deriveddata> getOutDataMap() {
			return outDataMap;
		}
		
		public String toString() {
			StringBuffer buf = new StringBuffer();
			buf.append("ExTransformData::[");
			buf.append(et);
			buf.append("\nInputs:\n");
			for (Map.Entry<Transforminputdata, Deriveddata> entry : inDataMap.entrySet()) {
				Transforminputdata tid = entry.getKey();
				Deriveddata dd = entry.getValue();
				buf.append("tid -> ").append(tid).append('\n');
				buf.append("dd -> ").append(dd).append('\n');				
			}
			buf.append("\nOutputs:\n");
			for (Map.Entry<Transformeddata, Deriveddata> entry : outDataMap.entrySet()) {
				Transformeddata td = entry.getKey();
				Deriveddata dd = entry.getValue();
				buf.append("td -> ").append(td).append('\n');
				buf.append("dd -> ").append(dd).append('\n');				
			}
			buf.append(']');
			return buf.toString();
		}
	}// ;

	public Set<BigDecimal> getAnalysisIDSet() {
		return analysisIDSet;
	}

}
