package clinical.web.soap;

import java.util.Iterator;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.utils.GenUtils;
import clinical.web.IDerivedDataService;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.common.security.DBConfig;
import clinical.web.helpers.SubCorticalVarInfo;
import clinical.web.services.DBPoolService;
import clinical.web.services.SimpleSecurityService;
import clinical.web.vo.SubjectDerivedDataStats;

/**
 * Web service for retrieving subject population descriptive statistics from the
 * database.
 * 
 * <pre>
 *    <ul>
 *    <li>fbirn.experimentID</li>
 *    <li>fbirn.dbid</li>
 *    <li>fbirn.dbid</li>
 *    <li>fbirn.users_file</li>
 *  </ul>
 *  </pre>
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SubcorticalStatsService.java,v 1.6 2006/04/19 01:24:57 bozyurt
 *          Exp $
 */
public class SubcorticalStatsService {
	protected static Properties props;
	private static Log log = LogFactory.getLog("SubcorticalStatsService");

	public SubcorticalStatsService() {
	}

	protected String prepareDerivedDataStatsForSubject(UserInfo ui,
			String subjectID, int experimentID, String[] popSubjectIds,
			String dbID) throws Exception {

		IDerivedDataService dds = ServiceFactory.getDerivedDataService(dbID);
		SubjectDerivedDataStats sdds = dds
				.getAllSubcorticalVolumeStatsForSubject(ui, subjectID,
						experimentID, popSubjectIds);
		String sep = " ";
		log.info("sdds has results " + sdds.iterator().hasNext());
		StringBuffer buf = new StringBuffer(1024);
		buf.append("subjectid=").append(subjectID).append(sep);
		for (Iterator<SubjectDerivedDataStats.DerivedVarStats> iter = sdds
				.iterator(); iter.hasNext();) {
			SubjectDerivedDataStats.DerivedVarStats dvs = iter.next();
			String varName = prepareVarName(dvs.getScVarInfo());
			buf.append(varName).append('=').append(dvs.getSubjectValue())
					.append(sep);
			buf.append(varName).append("_avg=").append(dvs.getAvg())
					.append(sep);
			buf.append(varName).append("_std=").append(dvs.getStd())
					.append(sep);
			buf.append(varName).append("_min=").append(dvs.getMin())
					.append(sep);
			buf.append(varName).append("_max=").append(dvs.getMax())
					.append(sep);
		}
		String stats = buf.toString();
		return stats;
	}

	public String getDerivedDataStatsForSubject(UserInfo ui, String dbID, String subjectID, int experimentID,
			String[] popSubjectIds) throws Exception {
		    System.out.println("subjectID =" + subjectID);
		    System.out.println(" popSubjectIds =" + popSubjectIds);
		    System.out.println(" popSubjectIds size =" + popSubjectIds.length);
			String result = prepareDerivedDataStatsForSubject(ui, subjectID,
					experimentID, popSubjectIds, dbID);
			return result;
	}

	protected void shutdown() {
		String dbID = props.getProperty("fbirn.dbid");
		try {
			DBPoolService.getInstance(dbID).shutdown();
		} catch (Exception x) {
		}
	}

	protected UserInfo startup() throws Exception {
		if (props == null) {
			props = GenUtils.loadProperties("clinical.properties");
		}
		Class.forName("oracle.jdbc.driver.OracleDriver");
		Class.forName("org.postgresql.Driver");

		String usersFile = props.getProperty("fbirn.users_file");
		String dbID = props.getProperty("fbirn.dbid");

		SimpleSecurityService secService = SimpleSecurityService
				.getInstance(usersFile);

		DBPoolService.getInstance(secService, secService.getDBConfigMap());
		DBPoolService poolService;
		for (DBConfig dbConfig : secService.getDBConfigMap().values()) {
			
			poolService = DBPoolService.getInstance(dbConfig.getId());
			poolService.startup();
			secService.prepareTableCache(dbConfig.getId());
		}

		UserInfo ui = secService.authenticate("admin", secService.getDBConfig(
				dbID).getUser("admin").getPwd(), dbID);
		return ui;
	}

	protected String prepareVarName(SubCorticalVarInfo svi) {
		StringBuffer buf = new StringBuffer();
		if (!svi.getLaterality().equalsIgnoreCase("n/a")) {
			buf.append(svi.getLaterality()).append('-');
		}
		buf.append(svi.getBrainRegionName());
		return buf.toString();
	}

}
