package clinical.web.tags;

import java.net.URLEncoder;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.struts.Globals;
import org.apache.struts.config.ModuleConfig;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ResultsNavigatorTag.java 84 2009-07-30 23:55:13Z bozyurt $
 */

public class ResultsNavigatorTag extends TagSupport {
	private static final long serialVersionUID = 703878627695629329L;
	protected int maxNumPages = 8;
	protected String prevPageAttr;
	protected String nextPageAttr;
	protected String pageAtAttr;
	protected String baseLink;
	protected Integer currentPage;
	protected Integer totalPages;
	protected String cssClass;

	public ResultsNavigatorTag() {}

	public int doStartTag() throws JspException {

		return SKIP_BODY;
	}

	public int doEndTag() throws JspException {
		try {
			int totNumPages = totalPages.intValue();
			int curPage = currentPage.intValue();

			// int numRanges = totNumPages / maxNumPages;
			// 0 based
			int curRange = (curPage - 1) / maxNumPages;
			int rangeStart = curRange * maxNumPages + 1;
			int rangeEnd = rangeStart + maxNumPages - 1;
			if (rangeEnd > totNumPages)
				rangeEnd = totNumPages;
			if ((rangeEnd - rangeStart + 1) < maxNumPages
					&& totNumPages > maxNumPages) {
				rangeStart = rangeEnd - maxNumPages + 1;
			}

			ModuleConfig config = (ModuleConfig) pageContext.getServletContext()
					.getAttribute(Globals.MODULE_KEY);
			HttpServletRequest request = (HttpServletRequest) pageContext
					.getRequest();

			String linkRoot = config.getPrefix() + request.getContextPath();

			if (baseLink.startsWith("/")) {
				linkRoot += baseLink;
			} else {
				linkRoot += "/" + baseLink;
			}

			String prevLink = linkRoot + "?action="
					+ URLEncoder.encode(prevPageAttr, "UTF-8");
			String nextLink = linkRoot + "?action="
					+ URLEncoder.encode(nextPageAttr, "UTF-8");

			StringBuffer sb = new StringBuffer();
			if (cssClass != null) {
				sb.append("<span class=\"").append(cssClass).append("\">");
			}
			if (curPage == 1) {
				sb.append(" << ");
			} else {
				sb.append("<a href=\"").append(prevLink).append("\" ").append(
						prepareClassAttribute(cssClass)).append("> << </a>\n");
			}
			for (int i = rangeStart; i <= rangeEnd; i++) {
				StringBuffer url = new StringBuffer(linkRoot);
				url.append("?action=").append(
						URLEncoder.encode(pageAtAttr, "UTF-8"));
				url.append("&page=").append(i);
				if (i == curPage) {
					sb.append("(").append(i).append(")\n");
				} else {
					sb.append("<a href=\"").append(url.toString()).append("\" ");
					sb.append(prepareClassAttribute(cssClass)).append(">");
					sb.append(i).append("</a>\n");
				}
			}
			if (curPage == totNumPages) {
				sb.append(" >> ");
			} else {
				sb.append("<a href=\"").append(nextLink).append("\" ").append(
						prepareClassAttribute(cssClass)).append("> >> </a>\n");

			}
			if (cssClass != null) {
				sb.append("</span>");
			}

			pageContext.getOut().println(sb.toString());
		} catch (Throwable t) {
			t.printStackTrace();
			throw new JspTagException(t.getMessage());
		}
		return EVAL_PAGE;
	}

	protected String prepareClassAttribute(String cssClass) {
		if (cssClass == null)
			return null;
		StringBuffer sb = new StringBuffer();
		sb.append(" class=\"").append(cssClass).append("\" ");
		return sb.toString();
	}

	// ---------------------- setters --------------
	public void setMaxNumPages(int newMaxNumPages) {
		this.maxNumPages = newMaxNumPages;
	}

	public void setPrevPageAttr(String newPrevPageAttr) {
		this.prevPageAttr = newPrevPageAttr;
	}

	public void setNextPageAttr(String newNextPageAttr) {
		this.nextPageAttr = newNextPageAttr;
	}

	public void setPageAtAttr(String newPageAtAttr) {
		this.pageAtAttr = newPageAtAttr;
	}

	public void setBaseLink(String newBaseLink) {
		this.baseLink = newBaseLink;
	}

	public void setCurrentPage(Integer newCurrentPage) {
		this.currentPage = newCurrentPage;
	}

	public void setTotalPages(Integer newTotalPages) {
		this.totalPages = newTotalPages;
	}

	public void setCssClass(String newCssClass) {
		this.cssClass = newCssClass;
	}

	// ---------------------- getters --------------
	public int getMaxNumPages() {
		return this.maxNumPages;
	}

	public String getPrevPageAttr() {
		return this.prevPageAttr;
	}

	public String getNextPageAttr() {
		return this.nextPageAttr;
	}

	public String getPageAtAttr() {
		return this.pageAtAttr;
	}

	public String getBaseLink() {
		return this.baseLink;
	}

	public Integer getCurrentPage() {
		return this.currentPage;
	}

	public Integer getTotalPages() {
		return this.totalPages;
	}

	public String getCssClass() {
		return this.cssClass;
	}

}