package clinical.web.tags.sec;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

import clinical.web.Constants;
import clinical.web.ServiceFactory;
import clinical.web.UserContainer;
import clinical.web.common.IAuthorizationService;
import clinical.web.exception.BaseException;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AuthorizedTag.java 62 2009-05-29 23:54:50Z bozyurt $
 */

public class AuthorizedTag extends TagSupport {
	private static final long serialVersionUID = 714421451938737030L;
	protected String privilege;

	public AuthorizedTag() {
	}

	public int doStartTag() throws JspException {
		HttpServletRequest req = (HttpServletRequest) pageContext.getRequest();
		HttpSession session = req.getSession(false);
		if (session == null)
			return SKIP_BODY;
		// check if there is a user container in the session (set after login
		// only)
		UserContainer userCon = (UserContainer) session
				.getAttribute(Constants.CONTAINER_KEY);

		if (userCon == null)
			return SKIP_BODY;
		try {
			if (privilege.equalsIgnoreCase("public")) {
				return EVAL_BODY_INCLUDE;
			}

			boolean negate = false;
			if (privilege.indexOf("not ") == 0) {
				negate = true;
				privilege = privilege.substring(4);
			}
			IAuthorizationService authService = ServiceFactory
					.getAuthorizationService();

			boolean authenticated = authService.isAuthorized(userCon
					.getUserInfo(), userCon.getDbID(), privilege);
			if (!negate && !authenticated) {
				return SKIP_BODY;
			}
			if (negate && authenticated) {
				return SKIP_BODY;
			}
		} catch (BaseException be) {
			throw new JspTagException(be.getMessage());
		}

		return EVAL_BODY_INCLUDE;
	}

	public void setPrivilege(String newPrivilege) {
		this.privilege = newPrivilege;
	}
}