package clinical.web.vo;

/**
 * @author I. Burak Ozyurt
 * @version $Id: AnalysisCompInfo.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class AnalysisCompInfo {
	protected AnalysisInfo analysis;
	protected int nodeLevel = -1;
	protected TransformationInfo transform;
	protected AnalysisCompInfo parent;
	protected Integer id;

	public AnalysisCompInfo() {
	}

	public AnalysisCompInfo(Integer id) {
		this.id = id;
	}

	public AnalysisInfo getAnalysis() {
		return analysis;
	}

	public void setAnalysis(AnalysisInfo analysis) {
		this.analysis = analysis;
	}

	public int getNodeLevel() {
		return nodeLevel;
	}

	public void setNodeLevel(int nodeLevel) {
		this.nodeLevel = nodeLevel;
	}

	public AnalysisCompInfo getParent() {
		return parent;
	}

	public void setParent(AnalysisCompInfo parent) {
		this.parent = parent;
	}

	public TransformationInfo getTransform() {
		return transform;
	}

	public Integer getId() {
		return id;
	}

	public void setTransform(TransformationInfo transform) {
		this.transform = transform;
	}

	public AnalysisCompInfo getRoot() {
		if ( parent == null) {
			return this;
		}
		AnalysisCompInfo p = this;
		while(p.getParent() != null) {
			p = p.getParent();
		}
		return p;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final AnalysisCompInfo other = (AnalysisCompInfo) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		return true;
	}
	
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("AnalysisCompInfo::[");
		buf.append("id=").append(id);
		buf.append(']');
		return buf.toString();
	}

}
