package clinical.web.vo;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: PropertyChangeTracker.java,v 1.5 2005/09/09 01:41:54 bozyurt
 *          Exp $
 * 
 */
public class PropertyChangeTracker {
	protected boolean keepTrackOfChanges = false;
	protected Map<String, String> changedFieldMap = null;
	protected static Log log = LogFactory.getLog("pct");

	public PropertyChangeTracker() {
	}

	public void setKeepTrackOfChanges(boolean newKeepTrackOfChanges) {
		this.keepTrackOfChanges = newKeepTrackOfChanges;
	}

	public boolean getKeepTrackOfChanges() {
		return this.keepTrackOfChanges;
	}

	public void keepTrackOfPropertyChange(int oldValue, int newValue,
			String propertyName) {
		if (!keepTrackOfChanges)
			return;
		if (oldValue != newValue) {
			setChangedProperty(propertyName);
		}
	}

	public void keepTrackOfPropertyChange(float oldValue, float newValue,
			String propertyName) {
		if (!keepTrackOfChanges)
			return;
		if (oldValue != newValue) {
			setChangedProperty(propertyName);
		}
	}

	public void keepTrackOfPropertyChange(boolean oldValue, boolean newValue,
			String propertyName) {
		if (!keepTrackOfChanges)
			return;
		if (oldValue != newValue) {
			setChangedProperty(propertyName);
		}
	}

	public void keepTrackOfPropertyChange(String oldValue, String newValue,
			String propertyName) {
		if (!keepTrackOfChanges)
			return;
		if (oldValue == null && newValue != null) {
			log.info("oldValue=" + oldValue + ",newValue=" + newValue);
			setChangedProperty(propertyName);
		}
		if ((oldValue != null && !oldValue.equals(newValue))) {
			log.info(">>>> oldValue=" + oldValue + ",newValue=" + newValue);
			setChangedProperty(propertyName);
		}
	}

	public void setChangedProperty(String propertyName) {
		if (changedFieldMap == null)
			changedFieldMap = new HashMap<String, String>(7);
		changedFieldMap.put(propertyName, propertyName);
	}

	public boolean hasChange() {
		return (changedFieldMap != null && !changedFieldMap.isEmpty());
	}

	public boolean isChanged(String propertyName) {
		return changedFieldMap.get(propertyName) != null;
	}
}
