package clinical.web.vo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.struts.util.LabelValueBean;

import clinical.server.vo.Researchgroup;
import clinical.server.vo.Researchgrouptype;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: StudyGroupInfo.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class StudyGroupInfo {
	protected String name = "";
	protected String description = "";
	/** research group ID */
	protected int ID;
	protected int experimentID;
	protected String experimentName;
	protected int researchGroupTypeID;
	protected ResearchGroupTypeInfo researchGroupType;
	protected List<LabelValueBean> rgTypeLVBeans;
	/** if true means the study group is persisted successfully. */
	protected boolean saved;

	public StudyGroupInfo() {
	}

	public StudyGroupInfo(Researchgroup rg) {
		this.name = rg.getName();
		this.description = rg.getDescription();
		this.ID = rg.getUniqueid().intValue();

	}

	// ---------------------- setters --------------
	public void setName(String newName) {
		this.name = newName;
	}

	public void setDescription(String newDescription) {
		this.description = newDescription;
	}

	public void setID(int newID) {
		this.ID = newID;
	}

	public void setExperimentID(int newExperimentID) {
		this.experimentID = newExperimentID;
	}

	public void setResearchGroupType(ResearchGroupTypeInfo newResearchGroupType) {
		this.researchGroupType = newResearchGroupType;
	}

	public void setExperimentName(String newExperimentName) {
		this.experimentName = newExperimentName;
	}

	public void setSaved(boolean newSaved) {
		this.saved = newSaved;
	}

	// ---------------------- getters --------------
	public String getName() {
		return this.name;
	}

	public String getDescription() {
		return this.description;
	}

	public int getID() {
		return this.ID;
	}

	public int getExperimentID() {
		return this.experimentID;
	}

	public ResearchGroupTypeInfo getResearchGroupType() {
		return this.researchGroupType;
	}

	public String getExperimentName() {
		return this.experimentName;
	}

	public boolean isSaved() {
		return this.saved;
	}

	public void setResearchGroupTypeLVBeans(List<Researchgrouptype> researchGroupTypes) {
		rgTypeLVBeans = new ArrayList<LabelValueBean>(researchGroupTypes.size());
		for(Researchgrouptype rgt : researchGroupTypes) {	
			rgTypeLVBeans.add(new LabelValueBean(rgt.getName(), rgt
					.getUniqueid().toString()));
		}
	}

	public Collection<LabelValueBean> getResearchGroupTypeLVBeans() {
		return rgTypeLVBeans;
	}

	public void setResearchGroupTypeID(int newResearchGroupTypeID) {
		this.researchGroupTypeID = newResearchGroupTypeID;
	}

	public int getResearchGroupTypeID() {
		return this.researchGroupTypeID;
	}

	public String toString() {
		StringBuffer sb = new StringBuffer(128);
		sb.append("StudyGroupInfo::[");
		sb.append("ID=").append(ID).append(", name=").append(name);
		if (researchGroupType != null) {
			sb.append(researchGroupType.toString());
		}
		sb.append(']');
		return sb.toString();
	}
}