package clinical.web.vo;

/**
 * Encapsulates study info for a particular segment
 * @author I. Burak Ozyurt
 * @version $Id: StudySegmentInfo.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class StudySegmentInfo {
  protected String subjectID;
  protected int experimentID;
  protected int studyID;
  protected String studyName;
  protected int visitID;
  protected int segmentID;
  protected Integer hc;
  public StudySegmentInfo() {}

  public StudySegmentInfo(String subjectID, int experimentID, int studyID,
                          String studyName, int visitID, int segmentID) {
    this.subjectID = subjectID;
    this.experimentID = experimentID;
    this.studyID = studyID;
    this.studyName = studyName;
    this.visitID = visitID;
    this.segmentID = segmentID;
  }

//---------------------- setters --------------

  public void setSubjectID(String newSubjectID) {
    this.subjectID = newSubjectID;
  }

  public void setExperimentID(int newExperimentID) {
    this.experimentID = newExperimentID;
  }

  public void setStudyID(int newStudyID) {
    this.studyID = newStudyID;
  }

  public void setStudyName(String newStudyName) {
    this.studyName = newStudyName;
  }

  public void setVisitID(int newVisitID) {
    this.visitID = newVisitID;
  }

  public void setSegmentID(int newSegmentID) {
    this.segmentID = newSegmentID;
  }

//---------------------- getters --------------
  public String getSubjectID() {
    return this.subjectID;
  }

  public int getExperimentID() {
    return this.experimentID;
  }

  public int getStudyID() {
    return this.studyID;
  }

  public String getStudyName() {
    return this.studyName;
  }

  public int getVisitID() {
    return this.visitID;
  }

  public int getSegmentID() {
    return this.segmentID;
  }

  public String toString() {
    StringBuffer buf = new StringBuffer(176);
    buf.append("StudySegmentInfo::[");
    buf.append("subjectID=").append(subjectID);
    buf.append(", experimentID=").append(experimentID);
    buf.append(", studyID=").append(studyID);
    buf.append(", studyName=").append(studyName);
    buf.append(", visitID=").append(visitID);
    buf.append(", segmentID=").append(segmentID);
    buf.append(']');
    return buf.toString();
  }

  public int hashCode() {
    if (hc == null) {
      StringBuffer buf = new StringBuffer(100);
      buf.append(subjectID).append('_').append(experimentID).append('_');
      buf.append(studyID).append('_').append(studyName).append('_');
      buf.append(visitID).append('_').append(segmentID);
      hc = new Integer(buf.toString().hashCode());
    }
    return hc.intValue();
  }

  public boolean equals(Object other) {
    if (other == null) {
      return false;
    }
    if (other == this) {
      return true;
    }
    if (! (other instanceof StudySegmentInfo)) {
      return false;
    }
    StudySegmentInfo that = (StudySegmentInfo) other;
    if ( (subjectID != null && that.subjectID != null &&
          subjectID.equals(that.subjectID)) &&
        experimentID == that.experimentID &&
        studyID == that.studyID &&
        ( studyName != null && that.studyName != null && studyName == that.studyName) &&
        visitID == that.visitID &&
        segmentID == that.segmentID) {
      return true;
    }
    return false;
  }
}
