package clinical.web.vo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: VisitDateQuery.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class VisitDateQuery {
	String subjectID;
	int visitID;
	int expID;

	public VisitDateQuery(String subjectID, int visitID, int expID) {
		super();
		this.subjectID = subjectID;
		this.visitID = visitID;
		this.expID = expID;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + expID;
		result = prime * result
				+ ((subjectID == null) ? 0 : subjectID.hashCode());
		result = prime * result + visitID;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final VisitDateQuery other = (VisitDateQuery) obj;
		if (expID != other.expID)
			return false;
		if (subjectID == null) {
			if (other.subjectID != null)
				return false;
		} else if (!subjectID.equals(other.subjectID))
			return false;
		if (visitID != other.visitID)
			return false;
		return true;
	}

	public String getSubjectID() {
		return subjectID;
	}

	public int getVisitID() {
		return visitID;
	}

	public int getExpID() {
		return expID;
	}

	
	public String getKey() {
		StringBuilder sb = new StringBuilder();
		sb.append(subjectID).append('_');
		sb.append(expID).append('_');
		sb.append(visitID);
		return sb.toString();
	}
}