package clinical.ws;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Set;

import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: BaseCLICLient.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public abstract class BaseCLICLient {
	protected String host = "localhost";
	protected int port = 8080;
	protected String contextName = "clinical";
	protected boolean useHTTPS = false;

	protected String getHostPort() {
		StringBuilder buf = new StringBuilder();
		if (useHTTPS) {
			buf.append("https://");
		} else {
			buf.append("http://");
		}
		buf.append(host);
		if (!useHTTPS && port > 0 && port < 30000 && port != 80) {
			buf.append(':').append(port);
		} else if (useHTTPS && port != 443 && port > 0 ) {
			buf.append(':').append(port);
		}
		return buf.toString();
	}

	protected void prepForHTTPS(Object port) {
		Client cxfClient = ClientProxy.getClient(port);
		HTTPConduit httpConduit = (HTTPConduit) cxfClient.getConduit();
		TLSClientParameters tlsCP = httpConduit.getTlsClientParameters();
		if (tlsCP == null)
			tlsCP = new TLSClientParameters();
		tlsCP.setSecureSocketProtocol("SSL");
		FiltersType filter = new FiltersType();
		filter.getInclude().add(".*_EXPORT_.*");
		filter.getInclude().add(".*_EXPORT1024_.*");
		filter.getInclude().add(".*_WITH_DES_.*");
		filter.getInclude().add(".*_WITH_NULL_.*");
		filter.getExclude().add(".*_DH_anon_.*");
		// set all the needed include and exclude filters.
		tlsCP.setCipherSuitesFilter(filter);
		httpConduit.setTlsClientParameters(tlsCP);
	}

	public static String loadXMLContent(String xmlFile) throws IOException {
		StringBuilder buf = new StringBuilder(120000);
		BufferedReader in = null;
		try {
			in = new BufferedReader(new FileReader(xmlFile), 4096);
			String line = null;
			while ((line = in.readLine()) != null) {
				if (line.startsWith("<?xml")) {
					continue;
				}
				buf.append(line).append("\n");
			}

			return buf.toString();
		} finally {
			if (in != null) {
				try {
					in.close();
				} catch (Exception x) {
				}
			}
		}
	}

	public static ArgInfo getArgValue(String[] args, int idx,
			Set<String> boolArgs) {
		if (boolArgs.contains(args[idx])) {
			return new ArgInfo("true", 1);
		}
		if (args.length <= (idx + 1)) {
			return null;
		}
		if (args[idx + 1].startsWith("-")) {
			return null;
		}
		String s = args[idx + 1];
		int i = idx + 2;
		int incr = 2;
		s = s.replaceFirst("^\"|'", "");
		while (i < args.length && !args[i].startsWith("-")) {
			String tok = args[i].replaceFirst("\"|'$", "");
			s += " " + tok;
			i++;
			incr++;
		}
		// System.out.println(">> " + s);
		return new ArgInfo(s, incr);
	}

	public static class ArgInfo {
		String argValue;
		int incr;

		public ArgInfo(String argValue, int idx) {
			super();
			this.argValue = argValue;
			this.incr = idx;
		}

		public String getArgValue() {
			return argValue;
		}

		public int getIncr() {
			return incr;
		}
	}

	public String getHost() {
		return host;
	}

	public void setHost(String host) {
		this.host = host;
	}

	public int getPort() {
		return port;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public String getContextName() {
		return contextName;
	}

	public void setContextName(String contextName) {
		this.contextName = contextName;
	}

	public boolean isUseHTTPS() {
		return useHTTPS;
	}

	public void setUseHTTPS(boolean useHTTPS) {
		this.useHTTPS = useHTTPS;
	}
}
