package clinical.ws.expimp.client;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;

import javax.xml.ws.BindingProvider;

import clinical.ws.BaseCLICLient;
import clinical.xml.export.XCEDE2Service;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: XCEDE2ServiceCLIClient.java,v 1.2 2008/08/25 17:24:02 bozyurt
 *          Exp $
 */
public class XCEDE2ServiceCLIClient extends BaseCLICLient {
	public XCEDE2ServiceCLIClient() {
		super();
	}

	public int[] getAllExperiments(String webUser, String pwd) throws Exception {
		XCEDE2Service port = getXCEDEService();
		int[] expIDs = port.getAllExperimentIDs(webUser, pwd);
		return expIDs;
	}

	protected XCEDE2Service getXCEDEService() {
		URL wsdlURL = getClass().getClassLoader().getResource(
				"XCEDE2Service.wsdl");
		System.out.println("wsdlURL=" + wsdlURL);
		XCEDE2ServiceClient client = new XCEDE2ServiceClient(wsdlURL);

		XCEDE2Service port = client.getXcede2Port();

		BindingProvider bp = (BindingProvider) port;
		String endPointAddress = getHostPort() + "/" + contextName
				+ "/services/XCEDE2Service";
		bp.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
				endPointAddress);
		System.out.println("EndPoint Address:"
				+ bp.getRequestContext().get(
						BindingProvider.ENDPOINT_ADDRESS_PROPERTY));
		if (useHTTPS) {
			System.out.println("Preparing for HTTPS connection");
			prepForHTTPS(port);
		}
		return port;
	}

	public int importAssessmentDataForSubject(String webUser, String pwd,
			String xcedeAssessment, String protocolID, int protocolVersion)
			throws Exception {
		XCEDE2Service port = getXCEDEService();

		return port.importAssessmentDataForSubject(webUser, pwd,
				xcedeAssessment, protocolID, protocolVersion);
	}

	public static void usage() {
		System.err.println("\n\n");
		System.err
				.println("Usage: XCEDE2ServiceCLIClient -u <webUser> -p <webUserPwd> -x <xcedeAssessmentFile> -i <protocolID> -v <protocolVersion> [-host <HID-web-app-host>] [-port <port-number>] [-context <context>] [-useSSL]");
		System.err.println("For example:\n");
		System.err
				.println("as_import.sh -u b -p b -i \"Subjects screening protocol\" -v 1 \\ ");
		System.err.println("-x ses.xcede \\");
		System.err.println("-host localhost -port 8080");
		System.err.println("-i protocolID");
		System.err
				.println("\tCorresponding Protocol ID from HID nc_protocol table");
		System.err.println("-v protocolVersion");
		System.err
				.println("\tCorresponding Protocol Version from HID nc_protocol table");

		System.err.println("-x xcedeAssessmentFile");
		System.err.println("\tfull path to the XCEDE2 assessment file");
		System.err.println("-host <HID-web-app-host>");
		System.err.println("\t(Default: localhost) e.g. loci.ucsd.edu");
		System.err.println("-port <port-number>");
		System.err.println("\t(Default: 8080)");
		System.err.println("-context <application-context>");
		System.err.println("\t(Default: clinical)");

		System.exit(1);
	}

	public static void main(String[] args) {
		try {
			String webUser = null;
			String pwd = null;
			String xcedeFile = null;
			String protocolID = "";
			int protocolVersion = 1;
			String host = null;
			String context = null;
			int port = -1;
			boolean useSSL = false;
			int i = 0;
			Set<String> boolArgs = new HashSet<String>(3);
			boolArgs.add("-useSSL");
			while (i < args.length) {
				ArgInfo ai = getArgValue(args, i, boolArgs);
				if (args[i].equals("-u")) {
					webUser = ai.getArgValue();
				} else if (args[i].equals("-p")) {
					pwd = ai.getArgValue();
				} else if (args[i].equals("-x")) {
					xcedeFile = ai.getArgValue();
				} else if (args[i].equals("-i")) {
					protocolID = ai.getArgValue();
				} else if (args[i].equals("-v")) {
					protocolVersion = Integer.parseInt(ai.getArgValue());
				} else if (args[i].equals("-host")) {
					host = ai.getArgValue();
				} else if (args[i].equals("-port")) {
					String portStr = ai.getArgValue();
					try {
						port = Integer.parseInt(portStr);
					} catch (NumberFormatException nfe) {
						port = -1;
					}
				} else if (args[i].equals("-context")) {
					context = ai.getArgValue();
				} else if (args[i].equals("-useSSL")) {
					useSSL = true;
				}
				i += ai.getIncr();
			}
			if (webUser == null || pwd == null || xcedeFile == null
					|| protocolID == null) {
				usage();
			}

			XCEDE2ServiceCLIClient client = new XCEDE2ServiceCLIClient();

			if (host != null)
				client.setHost(host);
			if (port != -1)
				client.setPort(port);
			if (context != null)
				client.setContextName(context);
			if (useSSL)
				client.setUseHTTPS(true);
			/*
			 * int[] expIDs = client.getAllExperiments(webUser, pwd); for (int
			 * expID : expIDs) { System.out.println("expID:" + expID); }
			 */

			String xcedeContent = BaseCLICLient.loadXMLContent(xcedeFile);

			int rc = client.importAssessmentDataForSubject(webUser, pwd,
					xcedeContent, protocolID, protocolVersion);
			System.exit(rc);
		} catch (Throwable t) {
			t.printStackTrace();
			System.exit(1);
		}

	}

	public String getHost() {
		return host;
	}

	public int getPort() {
		return port;
	}

	public void setHost(String host) {
		this.host = host;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public String getContextName() {
		return contextName;
	}

	public void setContextName(String contextName) {
		this.contextName = contextName;
	}

	public boolean isUseHTTPS() {
		return useHTTPS;
	}

	public void setUseHTTPS(boolean useHTTPS) {
		this.useHTTPS = useHTTPS;
	}
}
