package clinical.xml.export;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: Request.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class Request {
  protected String subjectID;
  protected int experimentID;
  protected int visitID;
  protected int studyID;
  protected int segmentID;

  public Request() {}

  public Request(String subjectID, int experimentID, int visitID, int studyID,
                 int segmentID) {
    this.subjectID = subjectID;
    this.experimentID = experimentID;
    this.visitID = visitID;
    this.studyID = studyID;
    this.segmentID = segmentID;
  }

//---------------------- setters --------------
  public void setSubjectID(String newSubjectID) {
    this.subjectID = newSubjectID;
  }

  public void setExperimentID(int newExperimentID) {
    this.experimentID = newExperimentID;
  }

  public void setVisitID(int newVisitID) {
    this.visitID = newVisitID;
  }

  public void setStudyID(int newStudyID) {
    this.studyID = newStudyID;
  }

  public void setSegmentID(int newSegmentID) {
    this.segmentID = newSegmentID;
  }

//---------------------- getters --------------
  public String getSubjectID() {
    return this.subjectID;
  }

  public int getExperimentID() {
    return this.experimentID;
  }

  public int getVisitID() {
    return this.visitID;
  }

  public int getStudyID() {
    return this.studyID;
  }

  public int getSegmentID() {
    return this.segmentID;
  }

  public String toString() {
    StringBuffer buf = new StringBuffer(152);
    buf.append("Request::[");
    buf.append("subjectID=").append(subjectID);
    buf.append(", experimentID=").append(experimentID);
    buf.append(", visitID=").append(visitID);
    buf.append(", studyID=").append(studyID);
    buf.append(", segmentID=").append(segmentID);
    buf.append(']');
    return buf.toString();
  }

  public boolean equals(Object other) {
    if (other == null) {
      return false;
    }
    if (other == this) {
      return true;
    }
    if (! (other instanceof Request)) {
      return false;
    }
    Request that = (Request) other;
    if ( (subjectID != null && that.subjectID != null &&
          subjectID.equals(that.subjectID)) &&
        experimentID == that.experimentID &&
        visitID == that.visitID &&
        studyID == that.studyID &&
        segmentID == that.segmentID) {
      return true;
    }
    return false;
  }

}
