package clinical.xml.importer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.jws.WebService;

import clinical.utils.Assertion;
import clinical.utils.FileUtils;
import clinical.utils.GenUtils;
import clinical.utils.XCEDEUtils;
import clinical.web.IAppConfigService;
import clinical.web.IXCEDEDerivedDataService;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.services.AppConfigService;
import clinical.xml.ApplicationUtils;
import clinical.xml.faults.ImportFault;
import clinical.xml.xcede2.AnalysisT;
import clinical.xml.xcede2.LevelDataRefsT;
import clinical.xml.xcede2.XCEDE;

/**
 * @author I. Burak Ozyurt
 * @version $Id: XCEDE2DDServiceImpl.java 62 2009-05-29 23:54:50Z bozyurt $
 */

@WebService(serviceName = "XCEDE2DDService", endpointInterface = "clinical.xml.importer.XCEDE2DDService")
public class XCEDE2DDServiceImpl implements XCEDE2DDService {

   public void importFSAnalyses(FreesurferAnalysis fsa) {
      BufferedInputStream in = null;
      BufferedOutputStream out = null;
      try {
         System.out.println("importFSAnalyses: SubjectID: "
               + fsa.getSubjectID());
         in = new BufferedInputStream(fsa.imageTarBall.getInputStream(), 4096);
         out = new BufferedOutputStream(new FileOutputStream(
               "/tmp/fs_tarball.tgz"), 4096);
         byte[] buf = new byte[4096];
         int bytesRead = -1;
         while ((bytesRead = in.read(buf)) != -1) {
            out.write(buf, 0, bytesRead);
         }

         System.out.println("wrote file /tmp/fs_tarball.tgz");
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         FileUtils.close(in);
         FileUtils.close(out);
      }

   }

   public int importFSAnalysesForSession(String webUser, String pwd,
         String mergedXcedeContent, String shortAnalysisName, String snapshotID)
         throws ImportFault {
      int rc = 0;
      try {
         String dbID = getDBID();
         UserInfo ui = ApplicationUtils.authenticate(webUser, pwd, dbID);
         System.out.println("ui=" + ui);
         System.out.println(mergedXcedeContent);
         importFreesurferAnalyses(ui, dbID, mergedXcedeContent,
               shortAnalysisName, snapshotID);

      } catch (Throwable t) {
         rc = 1;
         t.printStackTrace();
         throw new ImportFault(ApplicationUtils.prepareErrorMessage(t));
      }
      return rc;
   }

   protected void importFreesurferAnalyses(UserInfo ui, String dbID,
         String mergedXcedeContent, String shortAnalysisName, String snapshotID)
         throws Exception {
      List<AnalysisT> atList = loadMergedFSXCEDE(mergedXcedeContent);
      AnalysisT provenanceAT = findProvenanceAnalysis(atList);
      List<AnalysisT> remAtList = new ArrayList<AnalysisT>(atList.size() - 1);
      for (AnalysisT at : atList) {
         if (at != provenanceAT) {
            remAtList.add(at);
         }
      }
      LevelDataRefsT ldr = provenanceAT.getInput().get(0);
      String subjectID = ldr.getSubjectID();
      String expName = ldr.getProjectID();
      String visitStr = ldr.getVisitID();
      String[] toks = visitStr.split("__");
      int visitID = GenUtils.toInt(toks[1], -1);

      String segmentName = ldr.getEpisodeID();

      Assertion.assertTrue(visitID != -1);
      IXCEDEDerivedDataService xdds = ServiceFactory
            .getXCEDEDerivedDataService(dbID);

      xdds.addAnalysesForSubject(ui, subjectID, expName, visitID, segmentName,
            provenanceAT, remAtList, shortAnalysisName, snapshotID);
   }

   protected AnalysisT findProvenanceAnalysis(List<AnalysisT> analysisTypeList) {
      for (AnalysisT a : analysisTypeList) {
         if (!a.getInput().isEmpty() && !a.getProvenance().isEmpty()) {
            return a;
         }
      }
      return null;
   }

   public List<AnalysisT> loadMergedFSXCEDE(String mergedXcedeContent)
         throws Exception {
      XCEDE xcede = XCEDEUtils.unmarshalFromString(mergedXcedeContent);
      List<Object> aList = xcede.getAnnotationListOrRevisionListOrProject();
      List<AnalysisT> analysisTypes = new ArrayList<AnalysisT>(5);
      if (!aList.isEmpty() && aList.get(0) instanceof AnalysisT) {
         for (Iterator<?> it = aList.iterator(); it.hasNext();) {
            AnalysisT a = (AnalysisT) it.next();
            analysisTypes.add(a);
         }
      }
      return analysisTypes;
   }

   protected String getDBID() throws Exception {
      IAppConfigService cs = AppConfigService.getInstance();
      String dbID = cs.getParamValue("fbirn.dbid");

      if (dbID == null) {
         throw new Exception(
               "Cannot detect data source! Possible misconfiguration!");
      }
      return dbID;
   }

}
