<%@ page contentType="text/html;charset=UTF-8" language="java" %>

<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>

<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>

<style>

 #rpanel {
   float:left;
   padding:0px;
   padding-bottom: 1em;
   margin-left:10px;
   background-color: #d3d3d3;
   width: 70%;
 }

 .input_div {
   padding:5px;
 }

 .divMainSectionTitle {
    background-color: #00659c;
    color: #fff;
    font-weight: bold;
    font-size: larger;
    margin: 0px;
    padding: 0px;
 }

 .divSectionTitle {
    background-color: #00659c;
    color: #fff;
    font-weight: bold;
    margin: 0px;
    padding: 0px;
    padding-left:5px;
    padding-top:2px;
    padding-bottom:2px;
 }

div .label {
    float: left;
    font-weight:bold;
    width: 15em;
    text-align: right;
    margin-right: 10px;
    clear: left;
}

div .label2 {
    float: left;
    font-weight:bold;
    width: 25em;
    text-align: right;
    margin-right: 10px;
    clear: left;
}

div#tabpanel { float:left;
           width:70%;
           padding-top:10px;
        }
ul#tabs, ul#tabs li {list-style-type: none;
                   margin:0;
                   padding:0 }
ul#tabs { padding-left: 25px; }
ul#tabs li {float: left;
           width:91px;
           margin-right:2px;
           text-align: center;
          }

ul#tabs a { float:left;
           width:91px;
           padding: 2px 0 5px;
           text-decoration: none;
           background: #00659c;
           color: #999; }

ul#tabs li.activelink a, ul#tabs a:hover {color: #FFF; font-weight:bold;}


</style>

<script type="text/javascript">
  var helpSystem = null;
  window.addOnLoadListener(onLoadHandler);

  function go(elem,actionValue) {
      elem.form.action.value = actionValue;
      elem.form.submit();
      return false;
  }

  function switchView(elem, groupName) {
      var form = $('appConfForm');
      form.action.value = 'switchView';
      form.curGroupName.value = groupName;
      form.submit();
      return false;
  }

  function onLoadHandler() {
    var options = [];
    var url = '<html:rewrite page="/help.do?context=app_config"/>';
    helpSystem = new bal.AjaxHelpSystem(url, options);
  }
</script>




<div class="error">
  <html:errors/>
</div>

<form method="post" action="<c:url value="/aconf.do"/>" id="appConfForm">
  <html:hidden name="aconfForm" property="curGroupName"/>
  <input type="hidden" name="action" value="">

  <div id="tabpanel">
     <ul id="tabs">
        <c:forEach var="groupName" items="${aconfForm.groupNames}" >
          <c:if test="${aconfForm.curGroupName == groupName}" >
          <li class="activelink"><a href="#" ><c:out value="${groupName}"/></a></li>
          </c:if>
          <c:if test="${aconfForm.curGroupName != groupName}" >
             <li><a href="#" onclick="return switchView(this,'<c:out value="${groupName}"/>')"><c:out value="${groupName}"/></a></li>
          </c:if>
        </c:forEach>
     </ul>
  </div>
  <div id="rpanel">
     <div style="border-left: 2px #00659c solid; border-right: 2px #00659c solid;" >
       <c:if test="${aconfForm.curGroupName == 'General'}">
        <div>
          <div class="input_div">
            <span class="label" title="<c:out value="${aconfForm.fieldHelpMap.downloadCacheroot}"/>">Download Cache Root:</span>
            <html:text name="aconfForm" property="downloadCacheroot" size="40" maxlength="256" />
            <span id="help_10"> <button onclick="return helpHandler('help_10')">
               <img align="middle" class="help_button" src="images/questionmark.png" width="19" height="19">
               </button>
            </span>
          </div>

	     <div>
             &nbsp;
            <input type="submit" class="submit-button" value="Save" onclick="return go(this,'editGroup')"></input>
	     </div>
     </div>
     </c:if>

     <c:if test="${aconfForm.curGroupName == 'Advanced'}">
        <div >
          <div class="input_div" title="<c:out value="${aconfForm.fieldHelpMap.publicModeLogin}"/>">
             <c:if test="${aconfForm.publicModeLogin == 'true'}">
                <input type="checkbox" name="publicModeLogin" checked> <span>Operate in Public Mode(No login necessary)</span>
             </c:if>
            <c:if test="${aconfForm.publicModeLogin == 'false'}">
                <input type="checkbox" name="publicModeLogin"> <span>Operate in Public Mode(No login necessary)</span>
             </c:if>
             <span id="help_14"> <button onclick="return helpHandler('help_14')">
               <img align="middle" class="help_button" src="images/questionmark.png" width="19" height="19">
               </button>
             </span>
          </div>

          <div class="divSectionTitle">Database Version Checkup Setup</div>

          <div class="input_div" title="<c:out value="${aconfForm.fieldHelpMap.schemaVersionCheck}"/>">
             <c:if test="${aconfForm.schemaVersionCheck == 'true'}">
                <input type="checkbox" name="schemaVersionCheck" checked> <span>Check DB Schema Version</span>
             </c:if>
            <c:if test="${aconfForm.schemaVersionCheck == 'false'}">
                <input type="checkbox" name="schemaVersionCheck"> <span>Check DB Schema Version</span>
             </c:if>
             <span id="help_15"> <button onclick="return helpHandler('help_15')">
               <img align="middle" class="help_button" src="images/questionmark.png" width="19" height="19">
               </button>
             </span>
          </div>
          <div class="input_div">
             <span class="label2">DB Major Version Needed (Minimum): </span>
             <html:text name="aconfForm" property="minNeededMajorVersion" size="5" maxlength="10" />
          </div>
          <div class="input_div">
             <span class="label2">DB Major Version Needed (Maximum): </span>
             <html:text name="aconfForm" property="maxNeededMajorVersion" size="5" maxlength="10" />
          </div>
          <div class="input_div">
             <span class="label2">DB Minor Version Needed (Minimum): </span>
             <html:text name="aconfForm" property="minNeededMinorVersion" size="5" maxlength="10" />
          </div>
          <div class="input_div">
             <span class="label2">DB Minor Version Needed (Maximum): </span>
             <html:text name="aconfForm" property="maxNeededMinorVersion" size="5" maxlength="10" />
          </div>

          <div class="divSectionTitle">Notification Service Setup</div>

          <div class="input_div">
             <span class="label2" title="<c:out value="${aconfForm.fieldHelpMap.emailHost}"/>">Email Host: </span>
             <html:text name="aconfForm" property="emailHost" size="20" maxlength="100" />
             <span id="help_16"> <button onclick="return helpHandler('help_16')">
               <img align="middle" class="help_button" src="images/questionmark.png" width="19" height="19">
               </button>
             </span>
          </div>

          <div class="input_div">
             <span class="label2" title="<c:out value="${aconfForm.fieldHelpMap.emailUser}"/>">Email User: </span>
             <html:text name="aconfForm" property="emailUser" size="20" maxlength="100" />
             <span id="help_17"> <button onclick="return helpHandler('help_17')">
               <img align="middle" class="help_button" src="images/questionmark.png" width="19" height="19">
               </button>
             </span>
          </div>

          <div class="input_div">
             <span class="label2" title="<c:out value="${aconfForm.fieldHelpMap.emailPwd}"/>">Email Password: </span>
             <html:password name="aconfForm" property="emailPwd" size="20" maxlength="100" />
             <span id="help_18"> <button onclick="return helpHandler('help_18')">
               <img align="middle" class="help_button" src="images/questionmark.png" width="19" height="19">
               </button>
             </span>
          </div>

          <div class="input_div">
             <span class="label2" title="<c:out value="${aconfForm.fieldHelpMap.emailFrom}"/>">Email Sender: </span>
             <html:text name="aconfForm" property="emailFrom" size="20" maxlength="100" />
             <span id="help_19"> <button onclick="return helpHandler('help_19')">
               <img align="middle" class="help_button" src="images/questionmark.png" width="19" height="19">
               </button>
             </span>
          </div>

         <div class="divSectionTitle">Default Storage Type</div>
	     <div class="input_div">
             <span class="label2" title="<c:out value="${aconfForm.fieldHelpMap.storageType}"/>">Storage Type: </span>
             <html:select name="aconfForm" property="storageType">
               <html:option value="GRIDFTP">GridFTP</html:option>
               <html:option value="SRB">SRB</html:option>
               <html:option value="local">Mounted File System</html:option>
             </html:select>
             <span id="help_23"> <button onclick="return helpHandler('help_23')">
               <img align="middle" class="help_button" src="images/questionmark.png" width="19" height="19">
               </button>
             </span>
          </div>
          
          <div class="divSectionTitle">Globus MyProxy/GridFtp Setup</div>
          <div class="input_div" title="<c:out value="${aconfForm.fieldHelpMap.globusSecurityEnabled}"/>">
             <c:if test="${aconfForm.globusSecurityEnabled == 'true'}">
                <input type="checkbox" name="globusSecurityEnabled" checked> <span>Enable Globus Security Infrastructure</span>
             </c:if>
            <c:if test="${aconfForm.globusSecurityEnabled == 'false'}">
                <input type="checkbox" name="globusSecurityEnabled"> <span>Enable Globus Security Infrastructure</span>
             </c:if>            
          </div>
          <div class="input_div">
            <span class="label" title="<c:out value="${aconfForm.fieldHelpMap.globusMyproxyServerPrimary}"/>">Primary Myproxy server host:</span>
            <html:text name="aconfForm" property="globusMyproxyServerPrimary" size="40" maxlength="256" />           
          </div>
          <div class="input_div">
            <span class="label" title="<c:out value="${aconfForm.fieldHelpMap.globusMyproxyServerPort}"/>">Primary Myproxy server port:</span>
            <html:text name="aconfForm" property="globusMyproxyServerPort" size="5" maxlength="6" />           
          </div>
          <div class="input_div">
            <span class="label" title="<c:out value="${aconfForm.fieldHelpMap.globusMasterGridftpServer}"/>">Master Site GridFTP server host:</span>
            <html:text name="aconfForm" property="globusMasterGridftpServer" size="40" maxlength="256" />           
          </div>
          <div class="input_div">
            <span class="label" title="<c:out value="${aconfForm.fieldHelpMap.globusGridftpServerPort}"/>">GridFTP server port:</span>
            <html:text name="aconfForm" property="globusGridftpServerPort" size="5" maxlength="6" />           
          </div>
          <div class="input_div">
            <span class="label" title="<c:out value="${aconfForm.fieldHelpMap.globusRlsServerUrlPrimary}"/>">RLS server URL:</span>
            <html:text name="aconfForm" property="globusRlsServerUrlPrimary" size="40" maxlength="256" />           
          </div>
          
          
          <div>
            &nbsp;
            <input type="submit" class="submit-button" value="Save" onclick="return go(this,'editGroup')"></input>
	     </div>

     </div>
     </c:if>

     <c:if test="${aconfForm.curGroupName == 'Mediation'}">
        <div>
          <div class="input_div" title="<c:out value="${aconfForm.fieldHelpMap.queryonlyOperation}"/>">
             <c:if test="${aconfForm.queryonlyOperation == 'true'}">
                <input type="checkbox" name="queryonlyOperation" checked> <span>QueryOnly Operation</span>
             </c:if>
            <c:if test="${aconfForm.queryonlyOperation == 'false'}">
                <input type="checkbox" name="queryonlyOperation"> <span>QueryOnly Operation</span>
             </c:if>
             <span id="help_11"> <button onclick="return helpHandler('help_11')">
               <img align="middle" class="help_button" src="images/questionmark.png" width="19" height="19">
               </button>
            </span>
          </div>

          <div class="input_div">
            <span class="label" title="<c:out value="${aconfForm.fieldHelpMap.mediatorMappingFile}"/>">Mediator Mapping File:</span>
            <html:text name="aconfForm" property="mediatorMappingFile" size="40" maxlength="256" />
            <span id="help_12"> <button onclick="return helpHandler('help_12')">
               <img align="middle" class="help_button" src="images/questionmark.png" width="19" height="19">
               </button>
            </span>
          </div>

          <div class="input_div">
            <span class="label" title="<c:out value="${aconfForm.fieldHelpMap.mediatorSchemaName}"/>">Mediator Schema Name:</span>
            <html:text name="aconfForm" property="mediatorSchemaName" size="20" maxlength="50" />
            <span id="help_13"> <button onclick="return helpHandler('help_13')">
               <img align="middle" class="help_button" src="images/questionmark.png" width="19" height="19">
               </button>
            </span>
          </div>

	     <div>
            &nbsp; <input type="submit" class="submit-button" value="Save" onclick="return go(this,'editGroup')"></input>
	     </div>
     </div>
     </c:if>

     <c:if test="${aconfForm.curGroupName == 'Web Services'}">
        <div>
          <div class="input_div">
            <span class="label" title="<c:out value="${aconfForm.fieldHelpMap.fbirnDbid}"/>">DB ID for Web Services:</span>
            <html:text name="aconfForm" property="fbirnDbid" size="20" maxlength="50" />
           <span id="help_20"> <button onclick="return helpHandler('help_20')">
               <img align="middle" class="help_button" src="images/questionmark.png" width="19" height="19">
               </button>
            </span>
          </div>

	     <div>
            &nbsp;
            <input type="submit" class="submit-button" value="Save" onclick="return go(this,'editGroup')"></input>
	     </div>
     </div>
     </c:if>
   </div>

 <%-- rpanel end --%>
</div>
</form>

<script>
     var divElem = $('rpanel');
     Rico.Corner.round( divElem,  {color: "#00659c", corners: 'top bottom'});

     var tabs = $$('#tabs li');
     tabs.each(
         function(el) {
            Rico.Corner.round( el,  {color: "#00659c", corners: 'top'}); }
      );
</script>
