<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>


<script language='javascript' src='popcalendar.js'></script>

<script>
  function findElement(form, elemName) {
     var i;
     for(i=0; i < form.elements.length; ++i) {
        if ( form.elements[i].name == elemName)
           return form.elements[i];
     }
     return null;
  }

  function visitChanged(selectElem) {
     var selOption = selectElem.options[selectElem.selectedIndex];
     var form = selectElem.form;
     for(i=0; i < form.elements.length; ++i) {
        if ( form.elements[i].type == "hidden") {
          if ( form.elements[i].name == "selectedVisitID") {
              form.elements[i].value= selOption.value;
          }
          if ( form.elements[i].name == "action") {
             form.elements[i].value= "changeVisit";
          }
        }
     }
     form.submit();
  }

    function experimentChanged(selectElem) {
      var form = selectElem.form;
      for(i=0; i < form.elements.length; ++i) {
        if ( form.elements[i].type == "hidden") {
          if ( form.elements[i].name == "action") {
             form.elements[i].value= "changeExperiment";
          }
        }
     }
     form.submit();
    }

   function studyChanged(selectElem) {
     var selOption = selectElem.options[selectElem.selectedIndex];
     var form = selectElem.form;
     for(i=0; i < form.elements.length; ++i) {
        if ( form.elements[i].type == "hidden") {
          if ( form.elements[i].name == "selectedStudyID") {
              form.elements[i].value= selOption.value;
          }
          if ( form.elements[i].name == "action") {
             form.elements[i].value= "changeStudy";
          }
        }
     }
     form.submit();
  }

  function go(elem, actionValue) {
    elem.form.action.value =actionValue;
    elem.form.submit();
    return false;
  }
  
  // global var
  var exp2RGListMap = null;
  
  function onLoadHandler() {
      exp2RGListMap = <c:out value="${svmForm.exp2RGListJSON}" escapeXml="false" />;
      handleRGPopulation();
  }
  
  function handleRGPopulation() {
     var expSelector = document.getElementById('enrol1');
     var rgSelector = document.getElementById('enrol2');
     if ( !expSelector) return;
     var selExpId = expSelector.options[ expSelector.selectedIndex].value; 
     var rgInfo = exp2RGListMap[selExpId];
     if ( !rgInfo) return;
     var rgList = rgInfo.rgList;
     rgSelector.options.length = 0;   
     var elem = rgSelector;
     var selectedIdx = 0;
     for(var i = 0; i < rgList.length; i++) {
         if ( elem.form.selectedResearchGroupId.value == rgList[i].id) {
              selectedIdx = i;
              break;
         }       
     }
     
     for(var i = 0; i < rgList.length; i++) {
       var option = new Option( rgList[i].name, rgList[i].id);
       if ( i == selectedIdx) {
          option.selected=true;
          elem.form.selectedResearchGroupId.value = rgList[i].id;  
       }
       try {
         rgSelector.add(option,null);
       } catch(e) {
         rgSelector.add(option,-1);
       }
     }     
 }
 
 window.addOnLoadListener(onLoadHandler);
</script>

<div class="error">
<html:errors/>
</div>
<center>
<div>



<table border="0" cellspacing="0" cellpadding="2" bgcolor="#00659c" width="80%">
<tr>
 <td>


<table border="0" cellspacing="0" width="100%" bgcolor="white">
  <html:form action="/subjectman">
  <html:hidden name="svmForm" property="selectedVisitID"/>
  <html:hidden name="svmForm" property="selectedSegmentID"/>
  <html:hidden name="svmForm" property="selectedStudyID"/>
  <input type="hidden" name="action" value=""/>

  <%-- subject pane --%>
   <tr bgcolor="#d3d3d3">
      <td colspan="2" class="header">Subject</td>
   </tr>
  <tr>
    <td colspan="2">
    <table border="0" cellspacing="0" cellpadding="1" width="100%">
    <tr>
     <td nowrap>
     <span title="Unique subject ID"><b>Subject ID:</b>&nbsp;</span>
     <c:out value="${svmForm.subject.subjectID}"/>
     </td>
     <td><span title="Name of subject for local (protected) access only!"><b>Name (Protected):</b>&nbsp;</span> 
        <c:if test="${not empty svmForm.subject.name}" >  
          <c:out value="${svmForm.subject.name}" />
       </c:if>  
       <c:if test="${empty svmForm.subject.name}">  
          Not specified  
       </c:if>
      </td>
    </tr>
    <tr>
      <td><span title="Local identification number (protected)"><b>Local ID (Protected):</b></span></td>
      <td><span title="Birthdate of subject"><b>Birthdate (mm/dd/yyyy):</b>&nbsp;</span> 
       <c:if test="${not empty svmForm.subject.birthDate}">  
         <c:out value="${svmForm.subject.birthDate}" />
       </c:if>  
       <c:if test="${empty svmForm.subject.birthDate}">  
          Not specified  
       </c:if>

      </td>
    </tr>
    </table>
    </td>
  </tr>
<%-- experiment section --%>
 <tr bgcolor="#d3d3d3">
    <td colspan="2" class="header">Experiment</td>
 </tr>
 <c:if test="${not empty svmForm.currentVisit}">
 <tr>
  <td colspan="2">
     <table border="0" cellspacing="0" cellpadding="0" width="100%">
     <tr>
      <td><span class="msmall" title="Selected Experiment"><b>Experiment:</b></span>
        <bean:define id="expInfos" name="svmForm" property="expSelector.experimentInfos"
             type="java.util.Collection"/>

	<html:select name="svmForm"  property="expSelector.selectedExpID" onchange="experimentChanged(this)">
            <html:options collection="expInfos" property="value" labelProperty="label"/>
         </html:select>

      </td>
    </tr>
    </table>
  </td>
  </tr>
 </c:if> 
 <c:if test="${empty svmForm.currentVisit}">
 <tr>
  <td colspan="2">
     <table border="0" cellspacing="0" cellpadding="1" width="100%">
     <tr>
      <td><span title="Current Experiment"><b>Experiment Name:</b></span></td>

      <bean:define id="expInfos" name="svmForm" property="expSelector.experimentInfos"
                   type="java.util.Collection"/>

      <td> <html:select name="svmForm"  property="expSelector.selectedExpID" 
                 onchange="experimentChanged(this)">
            <html:options collection="expInfos" property="value" labelProperty="label"/>
         </html:select>
       </td>
    </tr>
    </table>
  </td>
  </tr>
</c:if>

 <%-- visit section --%>
 <tr bgcolor="#d3d3d3">
    <td colspan="2" class="header">Visit</td>
 </tr>
  <logic:notEmpty name="svmForm" property="currentVisit">
  <%-- <c:if test="${not empty svmForm.currentVisit}"> --%>
  <tr>
    <td colspan="2"><span title="Visit number in this experiment"><b>Visit Number:</b>&nbsp;<bean:write name="svmForm" property="currentVisit.visit.componentID"/></span></td>
 </tr>
  <tr>
   <td colspan="2">
     <table border="0" cellspacing="0" cellpadding="1" width="100%">
      <tr>
      <bean:define id="visitDates" name="svmForm" property="visitDates"
           type="java.util.Collection"/>
       
       <td colspan="4">
       <table border="0" cellspacing="0" cellpadding="1" width="100%">
        <tr>
       <td><span class="msmall" title="Date of this visit"><b>Visit Date:</b></span></td>
         <td> <html:select name="svmForm" property="visitDateValue" onchange="visitChanged(this)" >
                  <html:options collection="visitDates" property="value"  labelProperty="label"/>
              </html:select>
         </td>

         <bean:define id="visitTypes" name="svmForm" property="currentVisit.visitTypes"
           type="java.util.Collection"/>
         <td><span title="Type of this visit"><b>Visit Type:</b></span></td>
         <td> <bean:write name="svmForm" property="currentVisit.visitType"/> </td>
         </tr>
         <tr>
            <td><span title="Name of the visit"><b>Label:</b></span>
            <td>  <c:out value="${svmForm.currentVisit.visit.name}" /> <td>
            <td> &nbsp; </td>
            <td> &nbsp; </td>  
          </tr>
          </table> 
        </td>  
         <td><span title="Description of this visit"><b>Description:</b></span></td>
         <td> <html:textarea name="svmForm" property="currentVisit.visit.description" cols="40" rows="5"/></td>
      </tr>
      <tr>
              <td colspan="6" align="right">
                 <html:submit title="Add a new visit for the subject in the experiment" styleClass="submit-button" onclick="return go(this,'New Visit')" >
                        <bean:message key="button.show_visit_add"/></html:submit>
                  &nbsp;
                  <html:submit title="Edit the selected visit for this subject in this experiment" styleClass="submit-button" onclick="return go(this,'Show Visit Edit')" >Edit</html:submit>

                  &nbsp;
              </td>
      </tr>
      <tr><td colspan="6">&nbsp;</td></tr>
    </table>
   </td>
  </tr>
  <%-- studies section --%>
 <tr bgcolor="#d3d3d3">
    <td colspan="2" class="header">Studies</td>
 </tr>
 <tr>
   <td colspan="2">
     <table border="0" cellspacing="0" cellpadding="1" width="100%">
       <logic:notEmpty name="svmForm" property="currentVisit.studyFormInfos">
       <tr>
          <bean:define id="studyInfos" name="svmForm" property="studySelector.studyInfos"
             type="java.util.Collection"/>
          <td align="left" colspan="2">
                 <span class="msmall" title="Name of this study within the visit">Study Label:</span>&nbsp;
                    <html:select name="svmForm" property="studySelector.selectedStudyID" onchange="studyChanged(this)">
                       <html:options collection="studyInfos" property="value" labelProperty="label"/>
                     </html:select>
          </td>
       </tr>
       <tr>
            <td colspan="2" align="right">
               <html:submit title="Add a new study to this visit" styleClass="submit-button" onclick="return go(this,'New Study')" >
                     <bean:message key="button.show_add_study"/></html:submit>
                &nbsp;
               <html:submit title="Edit this study" styleClass="submit-button" onclick="return go(this,'Show Edit Study')" >Edit</html:submit>
                  &nbsp;
            </td>
       </tr>
      </logic:notEmpty>
      <c:if test="${empty svmForm.currentVisit.studyFormInfos}">
         <tr>
            <td colspan="2" align="right">
               <html:submit styleClass="submit-button" onclick="return go(this,'New Study')" >
                     <bean:message key="button.show_add_study"/></html:submit>
                &nbsp;
            </td>
       </tr>
      </c:if>
     </table>
   </td> 
 </tr>
 <c:if test="${not empty svmForm.currentStudy}">
  <c:if test="${svmForm.currentStudy.defaultStudyAsString == 'false'}">
   <tr  bgcolor="#d3d3d3" >
      <td colspan="2" class="header">Segments</td>
   </tr>
    <tr> 
     <td colspan="2" align="right">
      <html:submit styleClass="submit-button" onclick="return go(this,'Manage')" >
       <bean:message key="button.segment_manage"/></html:submit> &nbsp;
      </td>
    </tr>
   <%-- System.out.println("%%%%%%%%%%%%%  currentStudy.segmentFormInfos"); --%>
   <logic:iterate id="sfi" name="svmForm" property="currentStudy.segmentFormInfos" indexId="idx">
   <tr>
    <td colspan="2">
        <table style="border-bottom: 2px dotted #00659c; margin-bottom: 4px;" border="0" cellspacing="0" cellpadding="0" width="100%">
           <tr>
              <td colspan="6"><b>Segment ID:</b>&nbsp;
                 <c:out value="${sfi.studySegment.segmentID}" />
		      </td>
           </tr>
           <tr>
               <td><b>Date:</b></td>          
               <td>  <c:out value="${sfi.date}"/></td>
               <td><b>Time:</b></td>
               <td> <bean:write name="sfi" property="time"/> </td>              
               <td><b>Protocol:</b></td>
               <td> <c:out value="${sfi.protocolValue}" />  </td>           
           </tr>
           <tr>
             <td><b>Label:</b></td>
             <td>  <c:out value="${sfi.name}"/> </td>
             <td><b>Description: </b></td>
              <td colspan="3">                
                 <c:out value="${sfi.description}" />
              </td>
           </tr>
        </table>
        <!-- segment table -->
     </td>
   </tr>
  </logic:iterate>
  </c:if>
</c:if>  
 
<%-- segments section --%>
 <logic:empty name="svmForm" property="currentStudy">
 <c:if test="${not empty svmForm.currentVisit.segmentFormInfos}">
    <tr  bgcolor="#d3d3d3" >
               <td colspan="2" class="header">Segments</td>
     </tr>
     <tr> 
        <td colspan="2" align="right">
           <html:submit title="Edit this segment within the study" styleClass="submit-button" onclick="return go(this,'Manage')" >
                        <bean:message key="button.segment_manage"/></html:submit> &nbsp;
        </td>
      </tr>
 </c:if>

 <c:if test="${empty svmForm.currentVisit.segmentFormInfos}">
    <tr  style="background-color: #d3d3d3;"  >
               <td colspan="2" class="header">Segments</td>
     </tr>
     <tr> 
        <td colspan="2" align="right">
           <html:submit styleClass="submit-button" onclick="return go(this,'New Segment')" >
                        <bean:message key="button.show_add_segment"/></html:submit> &nbsp;
        </td>
      </tr>
 </c:if>
 
 <logic:iterate id="sfi" name="svmForm" property="currentVisit.segmentFormInfos" indexId="idx">
   <tr>
    <td colspan="2">
        <table style="border-bottom: 2px dotted #00659c; margin-bottom: 4px;" 
             border="0" cellspacing="0" cellpadding="0" width="100%">
           <tr>
              <td colspan="6"><b>Segment ID:</b>&nbsp;
              <c:out value="${sfi.visitSegment.segmentID}"/>		  
               </td>
           </tr>
           <tr>
               <td><b>Date:</b></td>          
               <td> <c:out value="${sfi.date}"/> </td>
               <td><b>Time:</b></td>
               <td> <c:out value="${sfi.time}" /> </td>
               <td><b>Protocol:</b></td>
               <td> <c:out value="${sfi.protocolValue}" />  </td>
           
           </tr>
           <tr>
             <td><b>Label:</b></td>
             <td> <c:out value="${sfi.visitSegment.name}" /> </td>
             <td><b>Description:</b></td>
              <td colspan="3">
                 <c:out value="${sfi.visitSegment.description}" />                
              </td>
           </tr>
        </table>
        <!-- segment table -->
     </td>
   </tr>
 </logic:iterate>
 <%-- currentStudy is not set --%> 
 </logic:empty>
<%-- has currentVisit --%>
</logic:notEmpty>
<%-- no visits --%>
<logic:empty name="svmForm" property="currentVisit">
  <logic:equal name="svmForm" property="hasAssignedExperiments" value="true">
   <tr>
    <td colspan="2" align="right"> <html:submit styleClass="submit-button" onclick="return go(this,'New Visit')" >
                        <bean:message key="button.show_visit_add"/></html:submit>
                  &nbsp;
    </td>
   </tr>
  </logic:equal>
</logic:empty>

<c:if test="${svmForm.expSelector.numExperiments == 0}">
  <tr>
     <td colspan="2">
          <span style="color:red; font-weight:bold">Attention: No further action is necessary for 
			 FBIRN Phase 3 and Jensen Studies. The upload script will handle the rest!
			 </span>
	  </td>
  </tr>
   <tr>
      <bean:define id="enrollExpList" name="svmForm" property="enrollExperimentSelector.experimentInfos"
             type="java.util.Collection"/>
          <td align="left" colspan="2">
                 <span class="msmall" title="Name of the experiment to enroll the subject">Enroll to Experiment :</span>&nbsp;
                    <html:select styleId="enrol1" name="svmForm" 
                      property="enrollExperimentSelector.selectedExpID" onchange="handleRGPopulation();">
                       <html:options collection="enrollExpList" property="value" labelProperty="label"/>
                     </html:select> &nbsp;
                 <span class="msmall" >Research Group: </span>
                    <html:select styleId="enrol2" name="svmForm" property="selectedResearchGroupId" />
                 &nbsp;
                <html:submit styleClass="submit-button" onclick="return go(this,'Enroll')" >
                        <bean:message key="button.enroll.subject"/></html:submit>    
                     
          </td>
       </tr>
  </c:if>
</html:form>


</table>

</td>
</tr>
</table>
</center>
