#!/usr/bin/perl -w
# $Id: upload_files.pl,v 1.3 2004/10/07 19:24:50 bozyurt Exp $

use strict;
use Carp;
use srbutil;
use File::Basename;

sub usage() {
die<<EOF
  Usage: $0  <srb-series-collection> <local-file1> [<local-file2> .. <local-filen>]
EOF
}


sub set_permission {
  my ($args) = @_;
  my $cmd = "Schmod $args";
  my $rc = system($cmd);
  croak "problem in Schmod:$!" if ( $rc != 0);
}

sub main() {
    usage() if ( scalar(@ARGV) < 2);
    my $srb_col = shift @ARGV;
    my @local_files = ();
    while ( (my $file = shift @ARGV) ) {
	push @local_files, $file;
    } 
    srbutil::sinit();
    foreach my $file (@local_files) {
	my $cmd = "Sput $file $srb_col";
	my $rc = system($cmd);
	croak "problem in Sput:$!" if ( $rc != 0);
        my $srbFile =  basename $file;
	set_permission("r birn groups $srb_col/$srbFile");
	set_permission("r public npaci $srb_col/$srbFile");
	set_permission("r guestuser ucsd-bcc $srb_col/$srbFile");
       
    }
    srbutil::sexit();
}

main();
