package clinical.comm;

import org.jdom.Element;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: Fault.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class Fault implements IXMLSerializer {
  protected Struct struct;
  protected String cause;
  protected int faultCode;

  public Fault() {}

  public Fault(String cause, int faultCode) {
    this.cause = cause;
    this.faultCode = faultCode;
  }


  //---------------------- getters --------------
  public String getCause() { return this.cause; }
  public int getFaultCode() { return this.faultCode; }

  public Element toXML() {
    Struct st = new Struct();
    st.addMember("faultCode", new SimpleDataType("int","faultCode",String.valueOf(faultCode)));
    if (cause == null) {
      cause = "An unspecified error has occurred!";
    }
    st.addMember("cause", new SimpleDataType("string","cause",cause));
    Element e = new Element("fault");
    e.addContent( st.toXML() );
    return e;
  }

  public void initializeFromXML(Element e) {
    Element se = e.getChild("struct");
    Struct st = new Struct();
    st.initializeFromXML(se);
    this.cause = (String) Utils.getSimpleDataType( (SimpleDataType) st.getMember("cause"));
    Integer fc =   (Integer) Utils.getSimpleDataType( (SimpleDataType) st.getMember("faultCode"));
    if ( fc != null) {
      this.faultCode = fc.intValue();
    }
  }
}

