package clinical.server;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import clinical.server.vo.Expcomponent;
import clinical.server.vo.Expsegment;
import clinical.server.vo.Humansubject;
import clinical.server.vo.Subjexperiment;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ExperimentInfo.java 91 2009-08-17 23:38:26Z bozyurt $
 * 
 */
public class ExperimentInfo implements java.io.Serializable {
	private static final long serialVersionUID = -539109514418948250L;
	protected Subjexperiment subjectExp;
	protected Humansubject humanSubject;
	protected List<Expcomponent> visits = new LinkedList<Expcomponent>();
	protected Map<Expcomponent, List<Expsegment>> visitSegmentsMap = 
		new HashMap<Expcomponent, List<Expsegment>>(5);

	public ExperimentInfo() {
	}

	// ---------------------- setters --------------
	public void setSubjectExp(Subjexperiment newSubjectExp) {
		this.subjectExp = newSubjectExp;
	}

	public void setHumanSubject(Humansubject newHumanSubject) {
		this.humanSubject = newHumanSubject;
	}

	public void addVisit(Expcomponent visit) {
		if (!visits.contains(visit)) {
			visits.add(visit);
		}
	}

	public void addSegment(Expcomponent visit, Expsegment segment) {
		List<Expsegment> segments = null;
		if ((segments = visitSegmentsMap.get(visit)) == null) {
			segments = new LinkedList<Expsegment>();
			visitSegmentsMap.put(visit, segments);
		}
		segments.add(segment);
	}

	// ---------------------- getters --------------
	public Subjexperiment getSubjectExp() {
		return this.subjectExp;
	}

	public Humansubject getHumanSubject() {
		return this.humanSubject;
	}

	public List<Expcomponent> getVisits() {
		return this.visits;
	}

	public List<Expsegment> getSegments(BigDecimal visitID) {
		return visitSegmentsMap.get(visitID);
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();

		if (subjectExp != null) {
			buf.append(subjectExp.toString()).append("\n\t");
		}
		if (humanSubject != null) {
			buf.append(humanSubject.toString()).append("\n\t");
		}
		for (Iterator<Expcomponent> iter = visits.iterator(); iter.hasNext();) {
			Expcomponent visit = iter.next();
			buf.append(visit.toString()).append("\n\t");
		}

		for (Iterator<List<Expsegment>> iter = visitSegmentsMap.values().iterator(); iter
				.hasNext();) {
			List<Expsegment> segments = iter.next();
			for (Iterator<Expsegment> it = segments.iterator(); it.hasNext();) {
				Expsegment segment = it.next();
				buf.append("\n\t").append(segment.toString());
			}
		}
		return buf.toString();
	}
}
